/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.world.item.crafting.recipe;

import io.github.mortuusars.horseman.Horseman;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ComponentTransferringRecipe
extends CustomRecipe {
    private final Ingredient sourceIngredient;
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack result;

    public ComponentTransferringRecipe(CraftingBookCategory category, Ingredient sourceIngredient, NonNullList<Ingredient> ingredients, ItemStack result) {
        super(category);
        this.sourceIngredient = sourceIngredient;
        this.ingredients = ingredients;
        this.result = result;
    }

    @NotNull
    public RecipeSerializer<ComponentTransferringRecipe> getSerializer() {
        return Horseman.RecipeSerializers.COMPONENT_TRANSFERRING.get();
    }

    @NotNull
    public Ingredient getSourceIngredient() {
        return this.sourceIngredient;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.getResult();
    }

    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    public boolean matches(CraftingInput input, Level level) {
        if (this.getSourceIngredient().isEmpty() || this.ingredients.isEmpty()) {
            return false;
        }
        ArrayList<Ingredient> unmatchedIngredients = new ArrayList<Ingredient>((Collection<Ingredient>)this.ingredients);
        unmatchedIngredients.addFirst(this.getSourceIngredient());
        int itemsInCraftingGrid = 0;
        block0: for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (!stack.isEmpty()) {
                ++itemsInCraftingGrid;
            }
            if (itemsInCraftingGrid > this.ingredients.size() + 1) {
                return false;
            }
            if (unmatchedIngredients.isEmpty()) continue;
            for (int j = 0; j < unmatchedIngredients.size(); ++j) {
                if (!((Ingredient)unmatchedIngredients.get(j)).test(stack)) continue;
                unmatchedIngredients.remove(j);
                continue block0;
            }
        }
        return unmatchedIngredients.isEmpty() && itemsInCraftingGrid == this.ingredients.size() + 1;
    }

    @NotNull
    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        for (int index = 0; index < input.size(); ++index) {
            ItemStack itemStack = input.getItem(index);
            if (!this.getSourceIngredient().test(itemStack)) continue;
            return itemStack.transmuteCopy((ItemLike)this.getResultItem(registries).getItem());
        }
        return this.getResultItem(registries);
    }

    @NotNull
    public List<RecipeDisplay> display() {
        ArrayList<SlotDisplay> list = new ArrayList<SlotDisplay>(this.ingredients.stream().map(Ingredient::display).toList());
        list.addFirst(this.sourceIngredient.display());
        return List.of(new ShapelessCraftingRecipeDisplay(list, (SlotDisplay)new SlotDisplay.ItemSlotDisplay(this.result.getItem()), (SlotDisplay)new SlotDisplay.ItemSlotDisplay(Items.CRAFTING_TABLE)));
    }
}

