/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.world.item.crafting.recipe.serializer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.horseman.world.item.crafting.recipe.ComponentTransferringRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ComponentTransferringRecipeSerializer<T extends ComponentTransferringRecipe>
implements RecipeSerializer<T> {
    private final MapCodec<T> codec;
    private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec;

    public ComponentTransferringRecipeSerializer(String recipeName, String sourceName, RecipeConstructor<T> constructor) {
        this.codec = this.createCodec(recipeName, sourceName, constructor);
        this.streamCodec = this.createStreamCodec(constructor);
    }

    public ComponentTransferringRecipeSerializer(String serializedSourceIngredientName, RecipeConstructor<T> constructor) {
        this("component_transferring", serializedSourceIngredientName, constructor);
    }

    public ComponentTransferringRecipeSerializer(RecipeConstructor<T> constructor) {
        this("component_transferring", "source_ingredient", constructor);
    }

    @NotNull
    protected MapCodec<T> createCodec(String recipeTypeName, String sourceIngredientName, RecipeConstructor<T> constructor) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(CraftingRecipe::category), (App)Ingredient.CODEC.fieldOf(sourceIngredientName).forGetter(ComponentTransferringRecipe::getSourceIngredient), (App)Ingredient.CODEC.listOf().fieldOf("ingredients").flatXmap(list -> {
            if (list.isEmpty()) {
                return DataResult.error(() -> "No ingredients for %s recipe".formatted(recipeTypeName));
            }
            return list.size() > 9 ? DataResult.error(() -> "Too many ingredients for %s recipe. Maximum is: %s".formatted(9, recipeTypeName)) : DataResult.success((Object)NonNullList.of((Object)Ingredient.of((ItemLike)Items.BARRIER), (Object[])list.toArray(new Ingredient[0])));
        }, DataResult::success).forGetter(ComponentTransferringRecipe::getIngredients), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(ComponentTransferringRecipe::getResult)).apply((Applicative)instance, constructor::create));
    }

    @NotNull
    protected StreamCodec<RegistryFriendlyByteBuf, T> createStreamCodec(RecipeConstructor<T> constructor) {
        return StreamCodec.composite((StreamCodec)CraftingBookCategory.STREAM_CODEC, CraftingRecipe::category, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, ComponentTransferringRecipe::getSourceIngredient, (StreamCodec)ByteBufCodecs.collection(NonNullList::createWithCapacity, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC), ComponentTransferringRecipe::getIngredients, (StreamCodec)ItemStack.STREAM_CODEC, ComponentTransferringRecipe::getResult, constructor::create);
    }

    @NotNull
    public MapCodec<T> codec() {
        return this.codec;
    }

    @NotNull
    public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
        return this.streamCodec;
    }

    @FunctionalInterface
    public static interface RecipeConstructor<T extends ComponentTransferringRecipe> {
        public T create(CraftingBookCategory var1, Ingredient var2, NonNullList<Ingredient> var3, ItemStack var4);
    }
}

