/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.world.summoning;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Instrument;

public record BoundData(UUID owner, ResourceKey<Instrument> instrument) {
    public static final Codec<BoundData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.fieldOf("owner").forGetter(BoundData::owner), (App)ResourceKey.codec((ResourceKey)Registries.INSTRUMENT).fieldOf("instrument").forGetter(BoundData::instrument)).apply((Applicative)instance, BoundData::new));

    public BoundData(Player player, ResourceKey<Instrument> instrument) {
        this(player.getUUID(), instrument);
    }

    public boolean isBoundTo(UUID uuid) {
        return this.owner().equals(uuid);
    }

    public boolean isBoundTo(Player player) {
        return this.isBoundTo(player.getUUID());
    }
}

