/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.world.summoning;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.horseman.world.summoning.BoundData;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public record StoredBoundHorse(Optional<BoundData> boundData, CompoundTag tag, UUID uuid, Vec3 position, ResourceKey<Level> dimension, boolean isDead) {
    public static final Codec<StoredBoundHorse> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BoundData.CODEC.optionalFieldOf("bound_data").forGetter(StoredBoundHorse::boundData), (App)CompoundTag.CODEC.fieldOf("tag").forGetter(StoredBoundHorse::tag), (App)UUIDUtil.CODEC.fieldOf("uuid").forGetter(StoredBoundHorse::uuid), (App)Vec3.CODEC.fieldOf("position").forGetter(StoredBoundHorse::position), (App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).fieldOf("dimension").forGetter(StoredBoundHorse::dimension), (App)Codec.BOOL.optionalFieldOf("is_dead", (Object)false).forGetter(StoredBoundHorse::isDead)).apply((Applicative)instance, StoredBoundHorse::new));

    public StoredBoundHorse(AbstractHorse horse) {
        this(Optional.ofNullable(horse.getHorsemanBoundData()), StoredBoundHorse.saveToTag(horse), horse.getUUID(), horse.position(), (ResourceKey<Level>)horse.level().dimension(), horse.isDeadOrDying());
    }

    public static CompoundTag saveToTag(AbstractHorse horse) {
        TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)horse.registryAccess());
        output.putString("id", EntityType.getKey((EntityType)horse.getType()).toString());
        horse.saveWithoutId((ValueOutput)output);
        return output.buildResult();
    }

    public boolean isInSameDimension(Player player) {
        return this.isInSameDimension((ResourceKey<Level>)player.level().dimension());
    }

    public boolean isInSameDimension(ResourceKey<Level> dimension) {
        return this.dimension().equals(dimension);
    }
}

