/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.world.summoning;

import com.google.common.base.Preconditions;
import io.github.mortuusars.horseman.Config;
import io.github.mortuusars.horseman.Horseman;
import io.github.mortuusars.horseman.world.HitchableHorse;
import io.github.mortuusars.horseman.world.summoning.BoundData;
import io.github.mortuusars.horseman.world.summoning.CallResult;
import io.github.mortuusars.horseman.world.summoning.StoredBoundHorse;
import io.github.mortuusars.horseman.world.summoning.SummonDimensionHandling;
import io.github.mortuusars.horseman.world.summoning.SummoningStorage;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Summoning {
    protected final SummoningStorage storage;

    public Summoning(MinecraftServer server) {
        this.storage = (SummoningStorage)server.overworld().getDataStorage().computeIfAbsent(SummoningStorage.TYPE);
    }

    public SummoningStorage getStorage() {
        return this.storage;
    }

    public boolean isBound(AbstractHorse horse) {
        return horse.getHorsemanBoundData() != null;
    }

    @Nullable
    public StoredBoundHorse getBoundHorse(UUID owner, ResourceKey<Instrument> instrument) {
        return (StoredBoundHorse)this.getStorage().getBoundHorses().getOrDefault(owner, Collections.emptyMap()).get(instrument);
    }

    @Nullable
    public StoredBoundHorse getBoundHorse(Player owner, ResourceKey<Instrument> instrument) {
        return this.getBoundHorse(owner.getUUID(), instrument);
    }

    public Map<ResourceKey<Instrument>, StoredBoundHorse> getStoredHorsesOf(UUID owner) {
        return this.getStorage().getBoundHorses().computeIfAbsent(owner, id -> new HashMap());
    }

    public Map<ResourceKey<Instrument>, StoredBoundHorse> getStoredHorsesOf(Player owner) {
        return this.getStoredHorsesOf(owner.getUUID());
    }

    protected void addOrUpdateBoundHorse(AbstractHorse horse) {
        @Nullable BoundData data = horse.getHorsemanBoundData();
        if (data == null) {
            Horseman.LOGGER.warn("Tried to update a horse that does not have a bound data. Horse: {}", (Object)horse);
            return;
        }
        this.getStoredHorsesOf(data.owner()).put(data.instrument(), new StoredBoundHorse(horse));
        this.getStorage().setDirty();
    }

    public void bind(ServerLevel level, AbstractHorse horse, Player player, ResourceKey<Instrument> instrument) {
        this.unbindExistingHorse(level, player, instrument);
        horse.setHorsemanBoundData(new BoundData(player, instrument));
        this.addOrUpdateBoundHorse(horse);
    }

    public void unbindHorse(ServerLevel level, StoredBoundHorse boundHorse) {
        boundHorse.boundData().ifPresent(data -> this.getStoredHorsesOf(data.owner()).remove(data.instrument()));
        AbstractHorse abstractHorse = this.tryFindLoadedHorse(level, boundHorse.uuid());
        if (abstractHorse instanceof AbstractHorse) {
            AbstractHorse loadedHorse = abstractHorse;
            loadedHorse.setHorsemanBoundData(null);
        } else {
            this.getStorage().getUnboundHorses().add(boundHorse.uuid());
        }
        this.getStorage().setDirty();
    }

    public void unbindExistingHorse(ServerLevel level, Player player, ResourceKey<Instrument> instrument) {
        @Nullable StoredBoundHorse boundHorse = this.getBoundHorse(player, instrument);
        if (boundHorse != null) {
            this.unbindHorse(level, boundHorse);
        }
    }

    public CallResult call(ServerPlayer player, ResourceKey<Instrument> instrument) {
        ServerLevel level = player.level();
        @Nullable StoredBoundHorse boundHorse = this.getBoundHorse((Player)player, instrument);
        if (boundHorse == null) {
            return CallResult.NO_BOUND_HORSE;
        }
        if (boundHorse.isDead()) {
            return CallResult.HORSE_IS_DEAD;
        }
        @Nullable AbstractHorse existingHorse = this.tryFindLoadedHorse(level, boundHorse.uuid());
        if (existingHorse != null) {
            if (!this.isBound(existingHorse)) {
                return CallResult.ERROR_HORSE_IS_NOT_BOUND;
            }
            this.addOrUpdateBoundHorse(existingHorse);
            boundHorse = this.getBoundHorse((Player)player, instrument);
            Preconditions.checkNotNull((Object)boundHorse);
        }
        if (!this.dimensionsAreValid((Player)player, boundHorse)) {
            return CallResult.INVALID_DIMENSION;
        }
        if (!this.isInRange((Player)player, boundHorse)) {
            return CallResult.TOO_FAR;
        }
        if (existingHorse != null && this.canWalkInsteadOfResummoning((Player)player, existingHorse)) {
            return this.walkToPlayer(player, existingHorse);
        }
        return this.summonHorse(player, boundHorse);
    }

    protected CallResult walkToPlayer(ServerPlayer player, AbstractHorse horse) {
        AttributeInstance followRangeAttribute;
        HitchableHorse hitchableHorse;
        if (horse instanceof HitchableHorse && HitchableHorse.isHitched(hitchableHorse = (HitchableHorse)horse)) {
            horse.removeLeash();
        }
        if ((followRangeAttribute = horse.getAttribute(Attributes.FOLLOW_RANGE)) != null) {
            followRangeAttribute.setBaseValue(((Double)Config.Server.HORSE_SUMMONING_MAX_WALKING_DISTANCE.get()).doubleValue());
        }
        horse.getNavigation().moveTo((Entity)player, ((Double)Config.Server.HORSE_SUMMONING_WALK_MOVEMENT_SPEED.get()).doubleValue());
        this.addOrUpdateBoundHorse(horse);
        Horseman.CriteriaTriggers.HORSE_SUMMONED.get().trigger(player, horse);
        return CallResult.SUCCESS;
    }

    protected CallResult summonHorse(ServerPlayer player, @NotNull StoredBoundHorse boundHorse) {
        ServerLevel level = player.level();
        ValueInput input = TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)level.registryAccess(), (CompoundTag)boundHorse.tag());
        Optional type = EntityType.by((ValueInput)input);
        if (type.isEmpty()) {
            Horseman.LOGGER.error("Failed to get the type from a stored boundHorse data. 'id' probably wasn't saved properly. Tag '{}'.", (Object)boundHorse.tag());
            return CallResult.ERROR_ENTITY_NOT_CREATED;
        }
        @Nullable Entity entity = ((EntityType)type.get()).create((Level)player.level(), EntitySpawnReason.MOB_SUMMONED);
        if (!(entity instanceof AbstractHorse)) {
            Horseman.LOGGER.error("Created entity isn't an AbstractHorse but {}. Something went wrong.", (Object)entity);
            return CallResult.ERROR_ENTITY_NOT_CREATED;
        }
        AbstractHorse newHorse = (AbstractHorse)entity;
        newHorse.load(input);
        newHorse.setUUID(UUID.randomUUID());
        newHorse.setPos(player.getX(), player.getY(), player.getZ());
        if (!this.hasSpaceFor(level, (Player)player, newHorse)) {
            return CallResult.NO_SPACE;
        }
        player.level().addFreshEntity((Entity)newHorse);
        this.removeOldBoundHorse(level, boundHorse);
        this.addOrUpdateBoundHorse(newHorse);
        Horseman.CriteriaTriggers.HORSE_SUMMONED.get().trigger(player, newHorse);
        return CallResult.SUCCESS;
    }

    protected boolean dimensionsAreValid(Player player, StoredBoundHorse boundHorse) {
        return switch ((SummonDimensionHandling)((Object)Config.Server.HORSE_SUMMONING_DIMENSION_HANDLING.get())) {
            default -> throw new MatchException(null, null);
            case SummonDimensionHandling.ANY -> true;
            case SummonDimensionHandling.SAME -> boundHorse.isInSameDimension(player);
            case SummonDimensionHandling.WHITELIST -> {
                String playerDimension = player.level().dimension().location().toString();
                yield ((List)Config.Server.HORSE_SUMMONING_DIMENSIONS.get()).stream().anyMatch(dimension -> dimension.equals(playerDimension));
            }
            case SummonDimensionHandling.BLACKLIST -> {
                String playerDimension = player.level().dimension().location().toString();
                yield ((List)Config.Server.HORSE_SUMMONING_DIMENSIONS.get()).stream().noneMatch(dimension -> dimension.equals(playerDimension));
            }
        };
    }

    protected boolean isInRange(Player player, StoredBoundHorse boundHorse) {
        int maxDistance = (Integer)Config.Server.HORSE_SUMMONING_MAX_DISTANCE.get();
        if (maxDistance < 0) {
            return true;
        }
        int distance = (int)boundHorse.position().distanceTo(player.position());
        return distance <= maxDistance;
    }

    protected boolean canWalkInsteadOfResummoning(Player player, AbstractHorse horse) {
        return player.level().dimension().equals(horse.level().dimension()) && (double)player.distanceTo((Entity)horse) < (Double)Config.Server.HORSE_SUMMONING_MAX_WALKING_DISTANCE.get();
    }

    protected boolean hasSpaceFor(ServerLevel level, Player player, AbstractHorse horse) {
        StoredBoundHorse boundHorse = new StoredBoundHorse(horse);
        ValueInput input = TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)level.registryAccess(), (CompoundTag)boundHorse.tag());
        Optional type = EntityType.by((ValueInput)input);
        if (type.isEmpty()) {
            return false;
        }
        @Nullable Entity entity = ((EntityType)type.get()).create(player.level(), EntitySpawnReason.MOB_SUMMONED);
        if (!(entity instanceof AbstractHorse)) {
            return false;
        }
        AbstractHorse newHorse = (AbstractHorse)entity;
        newHorse.load(input);
        newHorse.setUUID(UUID.randomUUID());
        newHorse.setPos(player.getX(), player.getY(), player.getZ());
        return !newHorse.isInWall();
    }

    public boolean onHorseLoaded(ServerLevel level, AbstractHorse horse) {
        if (!this.isBound(horse)) {
            return false;
        }
        UUID entityUUID = horse.getUUID();
        if (this.getStorage().getHorsesToRemove().contains(entityUUID)) {
            this.getStorage().getHorsesToRemove().remove(entityUUID);
            this.getStorage().getUnboundHorses().remove(entityUUID);
            horse.ejectPassengers();
            return true;
        }
        if (this.getStorage().getUnboundHorses().contains(entityUUID)) {
            horse.setHorsemanBoundData(null);
            this.getStorage().getUnboundHorses().remove(entityUUID);
        }
        this.getStorage().setDirty();
        return false;
    }

    public void onHorseUnloaded(ServerLevel level, AbstractHorse horse) {
        if (this.isBound(horse)) {
            this.addOrUpdateBoundHorse(horse);
            if (horse.isDeadOrDying() && horse.getCustomName() == null) {
                Horseman.LOGGER.info("Bound horse has died at [{}, {}, {}].", new Object[]{(int)horse.getX(), (int)horse.getY(), (int)horse.getZ()});
            }
        }
    }

    @Nullable
    protected AbstractHorse tryFindLoadedHorse(ServerLevel level, UUID entityUuid) {
        for (ServerLevel dimension : level.getServer().getAllLevels()) {
            Entity entity = dimension.getEntity(entityUuid);
            if (!(entity instanceof AbstractHorse)) continue;
            AbstractHorse horse = (AbstractHorse)entity;
            return horse;
        }
        return null;
    }

    protected void removeOldBoundHorse(ServerLevel level, @NotNull StoredBoundHorse boundHorse) {
        boolean removed = false;
        for (ServerLevel dimension : level.getServer().getAllLevels()) {
            @Nullable Entity existingHorse = dimension.getEntity(boundHorse.uuid());
            if (existingHorse == null) continue;
            existingHorse.discard();
            removed = true;
            break;
        }
        if (!removed) {
            this.getStorage().getHorsesToRemove().add(boundHorse.uuid());
        }
        this.getStorage().setDirty();
    }
}

