/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.world.summoning;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.horseman.world.summoning.StoredBoundHorse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public class SummoningStorage
extends SavedData {
    public static final Codec<Map<ResourceKey<Instrument>, StoredBoundHorse>> PLAYER_HORSES_CODEC = Codec.unboundedMap((Codec)ResourceKey.codec((ResourceKey)Registries.INSTRUMENT), StoredBoundHorse.CODEC);
    public static final Codec<SummoningStorage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)UUIDUtil.CODEC, PLAYER_HORSES_CODEC).optionalFieldOf("bound_horses", new HashMap()).forGetter(SummoningStorage::getBoundHorses), (App)Codec.list((Codec)UUIDUtil.CODEC).optionalFieldOf("unbound_horses", new ArrayList()).forGetter(SummoningStorage::getUnboundHorses), (App)Codec.list((Codec)UUIDUtil.CODEC).optionalFieldOf("horses_to_remove", new ArrayList()).forGetter(SummoningStorage::getHorsesToRemove)).apply((Applicative)instance, SummoningStorage::new));
    public static final SavedDataType<SummoningStorage> TYPE = new SavedDataType("horseman_horse_calling", SummoningStorage::new, CODEC, null);
    protected final Map<UUID, Map<ResourceKey<Instrument>, StoredBoundHorse>> boundHorses;
    protected final List<UUID> unboundHorses;
    protected final List<UUID> horsesToRemove;

    private SummoningStorage(Map<UUID, Map<ResourceKey<Instrument>, StoredBoundHorse>> boundHorses, List<UUID> unboundHorses, List<UUID> horsesToRemove) {
        this.boundHorses = boundHorses;
        this.unboundHorses = unboundHorses;
        this.horsesToRemove = horsesToRemove;
        this.setDirty();
    }

    private SummoningStorage() {
        this(new HashMap<UUID, Map<ResourceKey<Instrument>, StoredBoundHorse>>(), new ArrayList<UUID>(), new ArrayList<UUID>());
        this.setDirty();
    }

    public Map<UUID, Map<ResourceKey<Instrument>, StoredBoundHorse>> getBoundHorses() {
        return this.boundHorses;
    }

    public List<UUID> getUnboundHorses() {
        return this.unboundHorses;
    }

    public List<UUID> getHorsesToRemove() {
        return this.horsesToRemove;
    }
}

