/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.fabric;

import fuzs.forgeconfigapiport.fabric.api.v5.ConfigRegistry;
import io.github.mortuusars.horseman.Config;
import io.github.mortuusars.horseman.Horseman;
import io.github.mortuusars.horseman.HorsemanServer;
import io.github.mortuusars.horseman.network.fabric.FabricC2SPackets;
import io.github.mortuusars.horseman.network.fabric.FabricS2CPackets;
import io.github.mortuusars.horseman.world.item.CopperHornItem;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1496;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7441;
import net.minecraft.class_7706;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import org.jetbrains.annotations.Nullable;

public class HorsemanFabric
implements ModInitializer {
    @Nullable
    public static MinecraftServer server = null;

    public void onInitialize() {
        Horseman.init();
        ConfigRegistry.INSTANCE.register("horseman", ModConfig.Type.SERVER, (IConfigSpec)Config.Server.SPEC);
        ConfigRegistry.INSTANCE.register("horseman", ModConfig.Type.COMMON, (IConfigSpec)Config.Common.SPEC);
        ConfigRegistry.INSTANCE.register("horseman", ModConfig.Type.CLIENT, (IConfigSpec)Config.Client.SPEC);
        Horseman.Stats.register();
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41060).register(content -> content.getContext().comp_1253().method_46759(class_7924.field_41275).flatMap(registryLookup -> registryLookup.method_46733(class_7441.field_39108)).ifPresent(named -> named.method_40239().map(holder -> CopperHornItem.method_43558((class_1792)((class_1792)Horseman.Items.COPPER_HORN.get()), (class_6880)holder)).forEach(itemStack -> content.method_45417(itemStack, class_1761.class_7705.field_40191))));
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            HorsemanServer.serverStarted(server);
            HorsemanFabric.server = server;
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            HorsemanServer.serverStopped(server);
            HorsemanFabric.server = null;
        });
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            try {
                if (entity instanceof class_1496) {
                    class_1496 horse = (class_1496)entity;
                    if (world instanceof class_3218) {
                        class_3218 level = world;
                        if (HorsemanServer.getSummoning().onHorseLoaded(level, horse)) {
                            horse.method_31472();
                        }
                    }
                }
            }
            catch (Exception e) {
                Horseman.LOGGER.warn("Cannot handle Horseman's entityJoinLevel event. {}. But it shouldn't be a big deal.", (Object)e.getMessage());
            }
        });
        ServerEntityEvents.ENTITY_UNLOAD.register((entity, world) -> {
            try {
                if (entity instanceof class_1496) {
                    class_1496 horse = (class_1496)entity;
                    if (world instanceof class_3218) {
                        class_3218 level = world;
                        HorsemanServer.getSummoning().onHorseUnloaded(level, horse);
                    }
                }
            }
            catch (Exception e) {
                Horseman.LOGGER.warn("Cannot handle Horseman's entityLeaveLevel event. {}. But it shouldn't be a big deal.", (Object)e.getMessage());
            }
        });
        FabricC2SPackets.register();
        FabricS2CPackets.register();
    }
}

