/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.hitching;

import io.github.mortuusars.horseman.world.HitchableHorse;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1429;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_8181;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1496.class})
public abstract class AbstractHorseMixin
extends class_1429
implements HitchableHorse {
    @Unique
    protected final class_1263 horseman$leadAccess = AbstractHorseMixin.horseman$createLeadAccess(this.horseman$asHorse());
    @Unique
    protected class_1799 horseman$leadItem = class_1799.field_8037;
    @Unique
    protected boolean horseman$isHitched = false;

    protected AbstractHorseMixin(class_1299<? extends class_1429> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    public class_1799 horseman$getLead() {
        return this.horseman$leadItem;
    }

    @Override
    public void horseman$setLead(class_1799 stack) {
        this.horseman$leadItem = stack;
    }

    @Override
    public boolean horseman$isHitched() {
        return this.method_60953() && this.horseman$isHitched;
    }

    @Override
    public void horseman$setHitched(boolean hitched) {
        this.horseman$isHitched = hitched;
    }

    @Override
    public class_1263 horseman$getLeadAccess() {
        return this.horseman$leadAccess;
    }

    @Inject(method={"dropEquipment"}, at={@At(value="RETURN")})
    private void onDropEquipment(class_3218 level, CallbackInfo ci) {
        if (HitchableHorse.hasLead(this)) {
            this.method_5775(level, HitchableHorse.getLead(this));
            HitchableHorse.setLead(this, class_1799.field_8037);
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    protected void onAddAdditionalSaveData(class_11372 output, CallbackInfo ci) {
        class_1799 leadStack = this.horseman$getLead();
        if (!leadStack.method_7960()) {
            output.method_71468("HorsemanLeadItem", class_1799.field_24671, (Object)leadStack);
        }
        if (this.horseman$isHitched()) {
            output.method_71472("HorsemanHitched", true);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    protected void onReadAdditionalSaveData(class_11368 input, CallbackInfo ci) {
        this.horseman$leadItem = input.method_71426("HorsemanLeadItem", class_1799.field_24671).orElse(class_1799.field_8037);
        this.horseman$isHitched = input.method_71433("HorsemanHitched", false);
    }

    @Unique
    private static class_1263 horseman$createLeadAccess(final class_1496 horse) {
        return new class_8181(){
            private final class_1496 ownerHorse;
            {
                this.ownerHorse = horse;
            }

            @NotNull
            public class_1799 method_54079() {
                return ((HitchableHorse)horse).horseman$getLead();
            }

            public void method_54077(class_1799 item) {
                ((HitchableHorse)horse).horseman$setLead(item);
            }

            public void method_5431() {
            }

            public boolean method_5443(class_1657 player) {
                return player.method_5854() == this.ownerHorse || player.method_56094((class_1297)this.ownerHorse, 4.0);
            }
        };
    }
}

