/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.network.fabric;

import io.github.mortuusars.horseman.Horseman;
import io.github.mortuusars.horseman.fabric.HorsemanFabric;
import io.github.mortuusars.horseman.network.fabric.FabricC2SPackets;
import io.github.mortuusars.horseman.network.packet.Packet;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PacketsImpl {
    public static void sendToServer(Packet packet) {
        FabricC2SPackets.sendToServer(packet);
    }

    public static void sendToClient(Packet packet, class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
    }

    public static void sendToClients(Packet packet, Predicate<class_3222> filter) {
        if (HorsemanFabric.server == null) {
            Horseman.LOGGER.error("Cannot send a packet to players. Server is not available.");
            return;
        }
        for (class_3222 player : HorsemanFabric.server.method_3760().method_14571()) {
            if (!filter.test(player)) continue;
            PacketsImpl.sendToClient(packet, player);
        }
    }

    public static void sendToAllClients(Packet packet) {
        if (HorsemanFabric.server == null) {
            Horseman.LOGGER.error("Cannot send a packet to all players. Server is not available.");
            return;
        }
        for (class_3222 player : HorsemanFabric.server.method_3760().method_14571()) {
            PacketsImpl.sendToClient(packet, player);
        }
    }

    public static void sendToPlayersNear(Packet packet, @NotNull class_3218 level, @Nullable class_3222 excludedPlayer, double x, double y, double z, double radius) {
        PacketsImpl.sendToClients(packet, player -> {
            if (player != excludedPlayer && player.method_51469().method_27983() == level.method_27983()) {
                double d2;
                double d1;
                double d0 = x - player.method_23317();
                return d0 * d0 + (d1 = y - player.method_23318()) * d1 + (d2 = z - player.method_23321()) * d2 < radius * radius;
            }
            return false;
        });
    }

    public static void sendToPlayersTrackingEntity(class_1297 entity, Packet packet) {
        PacketsImpl.sendToAllClients(packet);
    }
}

