/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.mnaop.mixin;

import com.mna.api.affinity.Affinity;
import com.mna.api.capabilities.IWellspringNodeRegistry;
import com.mna.api.capabilities.WellspringNode;
import com.mna.capabilities.worlddata.WellspringNodeRegistry;
import io.yukkuric.mnaop.MNAOPConfig;
import io.yukkuric.mnaop.mixin_interface.IWellspringNode;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WellspringNodeRegistry.class})
public abstract class MixinWellspringSystem
implements IWellspringNodeRegistry {
    @Shadow(remap=false)
    @Final
    private static HashMap<UUID, HashMap<Affinity, Float>> player_diminishing_returns;

    @Inject(method={"insertPowerDiminishing"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void EmpoweredMatrix(UUID player, Level world, Affinity type, float amount, float diminish, CallbackInfoReturnable<Float> cir) {
        float ret;
        boolean empowered = MNAOPConfig.EmpoweredEldrinMatrix();
        boolean nonDiminishing = MNAOPConfig.NonDiminishingEldrinMatrix();
        if (!empowered && !nonDiminishing) {
            return;
        }
        if (nonDiminishing) {
            float mult = empowered ? this.getEldrinGenerationMultiplierFor(player, world, type) : 1.0f;
            ret = this.insertPower(player, world, type, mult * amount);
        } else {
            HashMap<Object, Float> levels = player_diminishing_returns.containsKey(player) ? player_diminishing_returns.get(player) : player_diminishing_returns.getOrDefault(player, new HashMap());
            float factor = levels.getOrDefault(type, Float.valueOf(1.0f)).floatValue();
            ret = this.insertPower(player, world, type, amount * factor);
            levels.put(type, Float.valueOf(factor * diminish));
            player_diminishing_returns.put(player, levels);
        }
        cir.setReturnValue((Object)Float.valueOf(ret));
        cir.cancel();
    }

    @Inject(method={"lambda$addRandomNode$2"}, at={@At(value="RETURN")}, remap=false)
    private static void afterGenRandomNode(CallbackInfoReturnable<WellspringNode> cir) {
        WellspringNode node = (WellspringNode)cir.getReturnValue();
        double smin = MNAOPConfig.NaturalWellspringMinStrength();
        double smax = MNAOPConfig.NaturalWellspringMaxStrength();
        ((IWellspringNode)IWellspringNode.class.cast(node)).setStrength(smin + Math.random() * (smax - smin));
    }

    @Inject(method={"lambda$addRandomNode$3"}, at={@At(value="RETURN")}, remap=false)
    private void afterGenRandomNode2(CallbackInfoReturnable<WellspringNode> cir) {
        MixinWellspringSystem.afterGenRandomNode(cir);
    }
}

