/*
 * Decompiled with CFR 0.152.
 */
package Gvoper.minygamez;

import Gvoper.minygamez.Scoreboard;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Dino {
    private static final int GAME_WIDTH = 225;
    private static final int GAME_HEIGHT = 225;
    private static final int GROUND_Y = 120;
    private static final int DINO_W = 18;
    private static final int DINO_H = 22;
    private static final int GROUND_HEIGHT = 4;
    private static final int CACTUS_WIDTH = 10;
    private static final int BIG_CACTUS_WIDTH = 20;
    private static final int SUPER_CACTUS_WIDTH = 30;
    private static final int ENEMY_SIZE = 15;
    private double dinoX = 30.0;
    private double dinoY = 98.0;
    private double dinoVY = 0.0;
    private boolean jumping = false;
    private int jumpCooldown = 0;
    private int legState = 0;
    private int tickCount = 0;
    private boolean waiting = true;
    private boolean gameOver = false;
    private boolean scoreSent = false;
    private int score = 0;
    private int lastScore = 0;
    private double cactusSpeed = -3.0;
    private final ArrayList<Cactus> cacti = new ArrayList();
    private final ArrayList<Cloud> clouds = new ArrayList();
    private final ArrayList<Enemy> enemies = new ArrayList();
    private int cactusTimer = 60;
    private int enemyTimer = 100;
    private int phantomCactusTimer = 100;
    private int doubleSpawnCount = 0;
    private int phantomCount = 0;
    private final Random random = new Random();

    public void init() {
        this.dinoX = 30.0;
        this.dinoY = 98.0;
        this.dinoVY = 0.0;
        this.jumping = false;
        this.jumpCooldown = 0;
        this.legState = 0;
        this.tickCount = 0;
        this.waiting = true;
        this.gameOver = false;
        this.scoreSent = false;
        this.score = 0;
        this.cactusSpeed = -3.0;
        this.cacti.clear();
        this.clouds.clear();
        this.enemies.clear();
        this.cactusTimer = 60;
        this.enemyTimer = 100;
        this.phantomCactusTimer = 100;
        this.doubleSpawnCount = 0;
        this.phantomCount = 0;
        int numClouds = 3 + this.random.nextInt(3);
        for (int i = 0; i < numClouds; ++i) {
            double cy;
            double cx;
            boolean valid;
            block1: do {
                valid = true;
                cx = this.random.nextDouble() * 225.0;
                cy = 20.0 + this.random.nextDouble() * 30.0;
                for (Cloud c : this.clouds) {
                    if (!(Math.abs(c.x - cx) < 30.0) || !(Math.abs(c.y - cy) < 30.0)) continue;
                    valid = false;
                    continue block1;
                }
            } while (!valid);
            this.clouds.add(new Cloud(cx, cy));
        }
        this.lastScore = Scoreboard.getPlayerScore("Dino", Minecraft.m_91087_().f_91074_.m_20148_());
    }

    public void tick() {
        boolean isBig;
        double newX;
        ++this.tickCount;
        if (this.waiting || this.gameOver) {
            return;
        }
        this.dinoVY += 1.0;
        this.dinoY += this.dinoVY;
        if (this.dinoY >= 98.0) {
            this.dinoY = 98.0;
            this.dinoVY = 0.0;
            this.jumping = false;
            this.jumpCooldown = Math.max(0, this.jumpCooldown - 1);
        }
        for (Enemy enemy : this.enemies) {
            if (!(this.dinoX + 18.0 > enemy.x) || !(this.dinoX < enemy.x + 15.0) || !(this.dinoY + 22.0 > enemy.y) || !(this.dinoY < enemy.y + 15.0)) continue;
            this.jumping = false;
            this.dinoVY = 0.0;
            break;
        }
        for (Cloud cloud : this.clouds) {
            cloud.x -= 1.0;
            if (!(cloud.x < -20.0)) continue;
            cloud.x += 245.0;
        }
        ArrayList<Cactus> newCacti = new ArrayList<Cactus>();
        for (Cactus cactus : this.cacti) {
            int width;
            double newX2 = cactus.x + this.cactusSpeed;
            int n = cactus.isSuper ? 30 : (width = cactus.isBig ? 20 : 10);
            if (newX2 + (double)width >= 0.0) {
                newCacti.add(new Cactus(newX2, cactus.height, cactus.isBig, cactus.isSuper, cactus.isPhantom, Math.max(0, cactus.pulseTicks - 1)));
                if (newX2 < 0.0 && cactus.x >= 0.0) {
                    ++this.score;
                }
            }
            if (!cactus.isPhantom || !(newX2 + (double)width < 0.0)) continue;
            --this.phantomCount;
        }
        this.cacti.clear();
        this.cacti.addAll(newCacti);
        ArrayList<Enemy> arrayList = new ArrayList<Enemy>();
        for (Enemy e : this.enemies) {
            newX = e.x + this.cactusSpeed;
            if (!(newX + 15.0 >= 0.0)) continue;
            arrayList.add(new Enemy(newX, e.y));
        }
        this.enemies.clear();
        this.enemies.addAll(arrayList);
        --this.cactusTimer;
        if (this.cactusTimer <= 0) {
            boolean bl;
            boolean isNormal;
            boolean bl2 = true;
            double newX3 = 235.0;
            isBig = this.score > 300 && this.random.nextDouble() < 0.21;
            boolean isSuper = this.score > 2222 && this.random.nextDouble() < 0.25;
            boolean bl3 = isNormal = !isBig && !isSuper && this.random.nextDouble() < 0.7;
            if (isSuper) {
                newX3 = 255.0;
                isBig = false;
            } else if (isBig) {
                newX3 = 245.0;
            }
            if (!this.cacti.isEmpty()) {
                boolean bl4;
                double minDistance;
                Cactus lastCactus = this.cacti.get(this.cacti.size() - 1);
                double lastCactusRight = lastCactus.x + (double)(lastCactus.isSuper ? 30 : (lastCactus.isBig ? 20 : 10));
                double d = minDistance = this.doubleSpawnCount == 0 ? 100.0 : 50.0;
                if (225.0 - lastCactusRight < minDistance) {
                    boolean bl5 = false;
                }
                if (!this.cacti.isEmpty() && (this.cacti.get((int)(this.cacti.size() - 1)).isBig || this.cacti.get((int)(this.cacti.size() - 1)).isSuper)) {
                    boolean bl6 = false;
                }
                if (!(!isBig || this.cacti.isEmpty() || lastCactus.isBig || lastCactus.isSuper || lastCactus.isPhantom)) {
                    bl4 = false;
                }
                if (this.doubleSpawnCount > 0 && bl4) {
                    double newRight = newX3 + (double)(isSuper ? 30 : (isBig ? 20 : 10));
                    if (newX3 < lastCactus.x + 5.0 && newRight > lastCactusRight - 5.0) {
                        bl = false;
                    }
                }
            }
            if (bl && (isNormal || isBig || isSuper)) {
                int height = isSuper ? 35 + this.random.nextInt(15) : (isBig ? 30 + this.random.nextInt(20) : (this.doubleSpawnCount > 0 ? 20 + this.random.nextInt(10) : 20 + this.random.nextInt(20)));
                this.cacti.add(new Cactus(newX3, height, isBig, isSuper, false));
                if (this.doubleSpawnCount > 0 || this.score <= 300 || this.random.nextDouble() >= 0.9) {
                    this.cactusTimer = 30 + this.random.nextInt(40);
                    this.doubleSpawnCount = 0;
                } else {
                    this.cactusTimer = 24;
                    ++this.doubleSpawnCount;
                }
            } else {
                this.cactusTimer = 10;
            }
        }
        --this.phantomCactusTimer;
        if (this.phantomCactusTimer <= 0 && this.score > 999) {
            double spawnChance;
            boolean bl;
            boolean bl7 = bl = this.score < 2111 || this.phantomCount < 3;
            double d = this.score >= 2111 ? 0.5 : (spawnChance = this.score >= 1444 ? 0.3 : 0.2);
            if (bl && this.random.nextDouble() < spawnChance) {
                isBig = this.random.nextDouble() < 0.1;
                int height = isBig ? 30 + this.random.nextInt(20) : 20 + this.random.nextInt(20);
                double newX4 = 225 + (isBig ? 20 : 10);
                this.cacti.add(new Cactus(newX4, height, isBig, false, true));
                ++this.phantomCount;
                this.phantomCactusTimer = this.score >= 2111 ? 20 + this.random.nextInt(40) : (this.score >= 1444 ? 30 + this.random.nextInt(50) : 40 + this.random.nextInt(60));
            } else {
                this.phantomCactusTimer = 10;
            }
        }
        --this.enemyTimer;
        if (this.enemyTimer <= 0 && this.score > 666) {
            double d;
            double d2 = this.score >= 2666 ? 0.7 : (d = this.score >= 1666 ? 0.5 : 0.3);
            if (this.random.nextDouble() < d) {
                double newY;
                newX = 240.0;
                int spawnType = this.random.nextInt(4);
                boolean canSpawn = true;
                switch (spawnType) {
                    case 0: {
                        newY = 105.0;
                        break;
                    }
                    case 1: {
                        newY = 105.0;
                        newX = this.cacti.isEmpty() ? newX : Math.max(240.0, this.cacti.get((int)(this.cacti.size() - 1)).x + (double)(this.cacti.get((int)(this.cacti.size() - 1)).isSuper ? 30 : (this.cacti.get((int)(this.cacti.size() - 1)).isBig ? 20 : 10)) + 50.0);
                        break;
                    }
                    case 2: {
                        double d3 = newY = this.cacti.isEmpty() ? 105.0 : (double)(120 - this.cacti.get((int)(this.cacti.size() - 1)).height - 15);
                        newX = this.cacti.isEmpty() ? newX : Math.max(240.0, this.cacti.get((int)(this.cacti.size() - 1)).x + (double)(this.cacti.get((int)(this.cacti.size() - 1)).isSuper ? 30 : (this.cacti.get((int)(this.cacti.size() - 1)).isBig ? 20 : 10)) + 50.0);
                        break;
                    }
                    default: {
                        newY = 20.0 + this.random.nextDouble() * 85.0;
                    }
                }
                for (Cactus c : this.cacti) {
                    int n = c.isSuper ? 30 : (c.isBig ? 20 : 10);
                    int width = n;
                    if (!(newX < c.x + (double)width) || !(newX + 15.0 > c.x) || !(newY < 120.0) || !(newY + 15.0 > (double)(120 - c.height))) continue;
                    canSpawn = false;
                    break;
                }
                for (Enemy e : this.enemies) {
                    if (!(newX < e.x + 15.0) || !(newX + 15.0 > e.x) || !(newY < e.y + 15.0) || !(newY + 15.0 > e.y)) continue;
                    canSpawn = false;
                    break;
                }
                if (canSpawn) {
                    this.enemies.add(new Enemy(newX, newY));
                    this.enemyTimer = this.score >= 2666 ? 30 + this.random.nextInt(30) : (this.score >= 1666 ? 40 + this.random.nextInt(40) : 50 + this.random.nextInt(50));
                } else {
                    this.enemyTimer = 10;
                }
            } else {
                this.enemyTimer = 10;
            }
        }
        if (this.score % 150 == 0 && this.score > 0) {
            this.cactusSpeed = Math.max(-6.0, this.cactusSpeed - 0.3);
        }
        for (Cactus c : this.cacti) {
            int width;
            if (c.isPhantom) continue;
            int n = c.isSuper ? 30 : (width = c.isBig ? 20 : 10);
            if (!(this.dinoX + 18.0 > c.x) || !(this.dinoX < c.x + (double)width) || !(this.dinoY + 22.0 > (double)(120 - c.height))) continue;
            this.gameOver = true;
            break;
        }
        ++this.score;
        if (!this.jumping && this.tickCount % 5 == 0) {
            this.legState = (this.legState + 1) % 2;
        }
        if (this.gameOver && !this.scoreSent) {
            Scoreboard.updateScore("Dino", Minecraft.m_91087_().f_91074_.m_20148_(), this.score);
            this.scoreSent = true;
        }
    }

    public void handleKey(int keyCode) {
        if (keyCode != 32) {
            return;
        }
        if (this.waiting) {
            this.waiting = false;
            return;
        }
        if (this.gameOver) {
            this.init();
            this.waiting = false;
            return;
        }
        if (!this.jumping && this.jumpCooldown <= 0) {
            this.dinoVY = -12.0;
            this.jumping = true;
            this.jumpCooldown = 3;
        }
    }

    public void keyReleased(int keyCode) {
        if (keyCode == 32 && this.dinoVY < -3.0) {
            this.dinoVY = -3.0;
        }
    }

    public void mouseClicked(double mouseX, double mouseY, int bookX, int bookY, int button) {
        if (button != 0) {
            return;
        }
        if (this.waiting) {
            this.waiting = false;
            return;
        }
        if (this.gameOver) {
            this.init();
            this.waiting = false;
            return;
        }
        double mx = mouseX - (double)bookX;
        double my = mouseY - (double)bookY;
        ArrayList<Enemy> newEnemies = new ArrayList<Enemy>();
        for (Enemy e : this.enemies) {
            if (mx >= e.x - 3.0 && mx <= e.x + 15.0 + 3.0 && my >= e.y - 3.0 && my <= e.y + 15.0 + 3.0) continue;
            newEnemies.add(e);
        }
        this.enemies.clear();
        this.enemies.addAll(newEnemies);
    }

    public void render(GuiGraphics g, Font font, int x, int y, int w, int h, float partial) {
        int cy;
        int cx;
        g.m_280024_(x, y, x + 225, y + 50, -7876885, -13421773);
        g.m_280509_(x, y + 50, x + 225, y + 225, -13421773);
        for (Cloud cloud : this.clouds) {
            cx = x + (int)cloud.x;
            cy = y + (int)cloud.y;
            g.m_280509_(cx - 1, cy - 1, cx + 20 + 1, cy + 10 + 1, -1996488705);
            g.m_280509_(cx, cy, cx + 20, cy + 10, -855638017);
        }
        g.m_280509_(x - 1, y + 120 - 1, x + 225 + 1, y + 120 + 4 + 1, -2007673515);
        g.m_280509_(x, y + 120, x + 225, y + 120 + 4, -11184811);
        for (int i = 0; i < 225; i += 10) {
            g.m_280509_(x + i, y + 120 + 4, x + i + 5, y + 120 + 4 + 2, -8947849);
        }
        for (Cactus cactus : this.cacti) {
            int width;
            cx = x + (int)cactus.x;
            cy = y + 120 - cactus.height;
            int n = cactus.isSuper ? 30 : (width = cactus.isBig ? 20 : 10);
            if (cactus.isPhantom) {
                int color = cactus.pulseTicks > 10 || cactus.pulseTicks <= 5 ? -870151390 : -14483678;
                g.m_280509_(cx - 1, cy - 1, cx + width + 1, y + 120 + 1, -14912228);
                g.m_280509_(cx, cy, cx + width, y + 120, color);
                continue;
            }
            g.m_280509_(cx - 1, cy - 1, cx + width + 1, y + 120 + 1, -2011002078);
            g.m_280509_(cx, cy, cx + width, y + 120, -14513374);
        }
        for (Enemy enemy : this.enemies) {
            int ex = x + (int)enemy.x;
            int ey = y + (int)enemy.y;
            g.m_280509_(ex - 1, ey - 1, ex + 15 + 1, ey + 15 + 1, -1996554240);
            g.m_280509_(ex, ey, ex + 15, ey + 15, -65536);
        }
        if (!this.gameOver) {
            int dx = x + (int)this.dinoX;
            int n = y + (int)this.dinoY;
            g.m_280509_(dx - 1, n - 1, dx + 18 + 1, n + 22 + 1, -2013202506);
            g.m_280024_(dx, n, dx + 18, n + 22, -16713802, 16758763);
            if (!this.jumping) {
                int legY = n + 22 - 4;
                g.m_280509_(dx + (this.legState == 0 ? 2 : 8), legY, dx + (this.legState == 0 ? 6 : 12), legY + 4, -16745871);
            }
        }
        g.m_280430_(font, (Component)Component.m_237110_((String)"minygamez.game.score", (Object[])new Object[]{this.score}), x + 10, y - 20, 0xFFFFFF);
        g.m_280430_(font, (Component)Component.m_237110_((String)"minygamez.game.last_score", (Object[])new Object[]{this.lastScore}), x + w - 100, y - 20, 0xFFFFFF);
        if (this.waiting) {
            g.m_280653_(font, (Component)Component.m_237115_((String)"minygamez.game.press_space"), x + w / 2, y + h / 2, 0xFFFFFF);
        } else if (this.gameOver) {
            g.m_280653_(font, (Component)Component.m_237110_((String)"minygamez.game.game_over", (Object[])new Object[]{this.score}), x + w / 2, y + h / 2 - 20, -43606);
            g.m_280653_(font, (Component)Component.m_237115_((String)"minygamez.game.press_space"), x + w / 2, y + h / 2, 0xFFFFFF);
        }
    }

    private static class Cloud {
        double x;
        double y;

        Cloud(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }

    private static class Enemy {
        double x;
        double y;

        Enemy(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }

    private static class Cactus {
        double x;
        int height;
        boolean isBig;
        boolean isSuper;
        boolean isPhantom;
        int pulseTicks;

        Cactus(double x, int height, boolean isBig, boolean isSuper, boolean isPhantom) {
            this(x, height, isBig, isSuper, isPhantom, isPhantom ? 14 : 0);
        }

        Cactus(double x, int height, boolean isBig, boolean isSuper, boolean isPhantom, int pulseTicks) {
            this.x = x;
            this.height = height;
            this.isBig = isBig;
            this.isSuper = isSuper;
            this.isPhantom = isPhantom;
            this.pulseTicks = pulseTicks;
        }
    }
}

