/*
 * Decompiled with CFR 0.152.
 */
package Gvoper.minygamez;

import Gvoper.minygamez.Scoreboard;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DoodleJump {
    private static final int GAME_WIDTH = 222;
    private static final int GAME_HEIGHT = 215;
    private static final int PLAYER_SIZE = 15;
    private static final int PLATFORM_WIDTH = 45;
    private static final int PLATFORM_HEIGHT = 10;
    private static final int BULLET_SIZE = 5;
    private static final int ENEMY_SIZE = 20;
    private static final int BLACK_HOLE_SIZE = 30;
    private double playerX;
    private double playerY;
    private double playerVY;
    private double cameraY;
    private ArrayList<Platform> platforms;
    private ArrayList<Bullet> bullets;
    private ArrayList<Enemy> enemies;
    private ArrayList<BlackHole> blackHoles;
    private int score;
    private boolean gameOver;
    private boolean waitingForInput;
    private boolean scoreSent;
    private int lastScore;
    private Random random = new Random();
    private double difficulty;
    private boolean leftPressed;
    private boolean rightPressed;

    public void init() {
        this.playerX = 111.0;
        this.playerY = 165.0;
        this.playerVY = 0.0;
        this.cameraY = 0.0;
        this.score = 0;
        this.gameOver = false;
        this.waitingForInput = true;
        this.scoreSent = false;
        this.difficulty = 1.0;
        this.leftPressed = false;
        this.rightPressed = false;
        this.lastScore = Scoreboard.getPlayerScore("DoodleJump", Minecraft.m_91087_().f_91074_.m_20148_());
        this.platforms = new ArrayList();
        this.bullets = new ArrayList();
        this.enemies = new ArrayList();
        this.blackHoles = new ArrayList();
        this.platforms.add(new Platform(this.playerX, this.playerY + 15.0, "green", 0.0));
        for (int i = 1; i < 6; ++i) {
            this.platforms.add(new Platform(this.random.nextDouble() * 177.0, 215 - i * 40, "green", 0.0));
        }
    }

    public void tick() {
        if (this.waitingForInput || this.gameOver) {
            return;
        }
        if (this.leftPressed) {
            this.playerX -= 6.0 * this.difficulty;
        }
        if (this.rightPressed) {
            this.playerX += 6.0 * this.difficulty;
        }
        if (this.playerX < 0.0) {
            this.playerX += 222.0;
        }
        if (this.playerX > 222.0) {
            this.playerX -= 222.0;
        }
        this.playerVY += 0.6 * this.difficulty;
        this.playerY += this.playerVY;
        if (this.playerVY > 0.0) {
            for (Platform p2 : this.platforms) {
                if (!p2.visible || p2.used && !p2.type.equals("green") && !p2.type.equals("blue") || !(this.playerX + 15.0 > p2.x) || !(this.playerX < p2.x + 45.0) || !(this.playerY + 15.0 > p2.y) || !(this.playerY + 15.0 - this.playerVY <= p2.y)) continue;
                if (p2.type.equals("brown")) {
                    p2.used = true;
                    p2.disappearTimer = 10;
                    this.playerVY = -10.0;
                    break;
                }
                if (p2.type.equals("white")) {
                    p2.used = true;
                    p2.visible = false;
                    this.playerVY = -10.0;
                    break;
                }
                if (p2.type.equals("spring")) {
                    p2.used = true;
                    this.playerVY = -18.0;
                    break;
                }
                if (p2.type.equals("jetpack")) {
                    p2.used = true;
                    this.playerVY = -30.0;
                    break;
                }
                this.playerVY = -10.0;
                break;
            }
        }
        for (Platform p2 : this.platforms) {
            if (p2.type.equals("blue")) {
                p2.x += p2.speed * this.difficulty;
                if (p2.x < 0.0) {
                    p2.x = 0.0;
                    p2.speed = -p2.speed;
                }
                if (p2.x > 177.0) {
                    p2.x = 177.0;
                    p2.speed = -p2.speed;
                }
            }
            if (!p2.type.equals("brown") || !p2.used || p2.disappearTimer <= 0) continue;
            --p2.disappearTimer;
            if (p2.disappearTimer > 0) continue;
            p2.visible = false;
        }
        if (this.playerY - this.cameraY < 107.0) {
            this.cameraY = this.playerY - 107.0;
        }
        double highestY = this.platforms.stream().mapToDouble(p -> p.y).min().orElse(0.0);
        while (highestY > this.cameraY - 40.0) {
            double x = this.random.nextDouble() * 177.0;
            double y = highestY - 20.0 - this.random.nextDouble() * 30.0;
            String type = this.score < 2000 ? "green" : (this.random.nextDouble() < 0.45 ? "green" : (this.random.nextDouble() < 0.5714 ? "blue" : (this.random.nextDouble() < 0.6 ? "brown" : (this.random.nextDouble() < 0.6667 ? "spring" : (this.random.nextDouble() < 0.8333 ? "white" : "jetpack")))));
            double speed = type.equals("blue") ? (this.random.nextDouble() * 2.0 - 1.0) * 3.0 : 0.0;
            this.platforms.add(new Platform(x, y, type, speed));
            if (this.score >= 2000) {
                if (this.random.nextDouble() < 0.03 + 0.05 * this.difficulty) {
                    boolean fast = this.score >= 5000 && this.random.nextDouble() < 0.2;
                    double espeed = fast ? (this.random.nextDouble() * 2.0 - 1.0) * 2.0 : 0.0;
                    this.enemies.add(new Enemy(this.random.nextDouble() * 202.0, y - 20.0, fast, espeed));
                }
                if (this.random.nextDouble() < 0.01 + 0.02 * this.difficulty) {
                    this.blackHoles.add(new BlackHole(this.random.nextDouble() * 192.0, y - 30.0));
                }
            }
            highestY = y;
        }
        this.platforms.removeIf(p -> p.y > this.cameraY + 215.0 + 50.0);
        this.enemies.removeIf(e -> e.y > this.cameraY + 215.0 + 50.0);
        this.blackHoles.removeIf(h -> h.y > this.cameraY + 215.0 + 50.0);
        for (Enemy e2 : this.enemies) {
            if (!e2.fast) continue;
            e2.x += e2.speed * this.difficulty;
            if (e2.x < 0.0) {
                e2.x = 0.0;
                e2.speed = -e2.speed;
            }
            if (!(e2.x > 202.0)) continue;
            e2.x = 202.0;
            e2.speed = -e2.speed;
        }
        for (Bullet b2 : this.bullets) {
            b2.y += b2.vy;
        }
        this.bullets.removeIf(b -> b.y < this.cameraY - 50.0);
        this.bullets.removeIf(b -> {
            for (Enemy e : this.enemies) {
                if (!(b.x + 5.0 > e.x) || !(b.x < e.x + 20.0) || !(b.y + 5.0 > e.y) || !(b.y < e.y + 20.0)) continue;
                --e.health;
                return true;
            }
            return false;
        });
        this.enemies.removeIf(e -> e.health <= 0);
        for (Enemy e2 : this.enemies) {
            if (!(this.playerX + 15.0 > e2.x) || !(this.playerX < e2.x + 20.0) || !(this.playerY + 15.0 > e2.y) || !(this.playerY < e2.y + 20.0)) continue;
            if (this.playerVY > 0.0 && this.playerY + 15.0 - this.playerVY <= e2.y) {
                this.playerVY = -10.0;
                this.enemies.remove(e2);
                break;
            }
            this.gameOver = true;
            break;
        }
        for (BlackHole h2 : this.blackHoles) {
            if (!(this.playerX + 15.0 > h2.x) || !(this.playerX < h2.x + 30.0) || !(this.playerY + 15.0 > h2.y) || !(this.playerY < h2.y + 30.0)) continue;
            this.gameOver = true;
            break;
        }
        if (this.playerY > this.cameraY + 215.0 + 50.0) {
            this.gameOver = true;
        }
        this.difficulty = 1.0 + (double)this.score / 15000.0;
        this.score = (int)Math.max((double)this.score, -this.cameraY);
        if (this.gameOver && !this.scoreSent) {
            Scoreboard.updateScore("DoodleJump", Minecraft.m_91087_().f_91074_.m_20148_(), this.score);
            this.scoreSent = true;
        }
    }

    public void handleKey(int keyCode) {
        if (this.waitingForInput) {
            if (keyCode == 263 || keyCode == 262) {
                this.waitingForInput = false;
            }
            return;
        }
        if (this.gameOver) {
            if (keyCode == 263 || keyCode == 262) {
                this.init();
                this.waitingForInput = false;
            }
            return;
        }
        if (keyCode == 263) {
            this.leftPressed = true;
        } else if (keyCode == 262) {
            this.rightPressed = true;
        } else if (keyCode == 32) {
            this.bullets.add(new Bullet(this.playerX + 7.0, this.playerY));
        }
    }

    public void keyReleased(int keyCode) {
        if (keyCode == 263) {
            this.leftPressed = false;
        } else if (keyCode == 262) {
            this.rightPressed = false;
        }
    }

    public boolean isGameOver() {
        return this.gameOver;
    }

    public void render(GuiGraphics guiGraphics, Font font, int bookX, int bookY, int bookWidth, int bookHeight, float partialTicks) {
        int gameX = bookX;
        int gameY = bookY;
        int centerX = bookX + bookWidth / 2;
        int centerY = bookY + bookHeight / 2;
        for (Platform p : this.platforms) {
            if (!p.visible) continue;
            int px = gameX + (int)p.x;
            int py = gameY + (int)(p.y - this.cameraY);
            if (py < gameY - 10 || py > gameY + 215) continue;
            int color = p.type.equals("green") ? -11184811 : (p.type.equals("blue") ? -16746570 : (p.type.equals("brown") ? -7650029 : (p.type.equals("spring") ? -16711936 : (p.type.equals("white") ? -1 : -22016))));
            int shadow = p.type.equals("spring") || p.type.equals("jetpack") ? -2013200640 : -2007673515;
            guiGraphics.m_280509_(px - 1, py - 1, px + 45 + 1, py + 10 + 1, shadow);
            guiGraphics.m_280509_(px, py, px + 45, py + 10, color);
            if (p.type.equals("spring") && !p.used) {
                guiGraphics.m_280509_(px + 15, py - 5, px + 30, py, -22016);
                continue;
            }
            if (!p.type.equals("jetpack") || p.used) continue;
            guiGraphics.m_280509_(px + 15, py - 5, px + 30, py - 2, -16713802);
        }
        for (Enemy e : this.enemies) {
            int ex = gameX + (int)e.x;
            int ey = gameY + (int)(e.y - this.cameraY);
            if (ey < gameY - 20 || ey > gameY + 215) continue;
            int color1 = e.fast ? -43776 : -65536;
            int color2 = e.fast ? -21931 : -43691;
            guiGraphics.m_280509_(ex - 1, ey - 1, ex + 20 + 1, ey + 20 + 1, -1996554240);
            guiGraphics.m_280024_(ex, ey, ex + 20, ey + 20, color1, color2);
        }
        for (BlackHole h : this.blackHoles) {
            int hx = gameX + (int)h.x;
            int hy = gameY + (int)(h.y - this.cameraY);
            if (hy < gameY - 30 || hy > gameY + 215) continue;
            guiGraphics.m_280509_(hx - 1, hy - 1, hx + 30 + 1, hy + 30 + 1, -2013265920);
            guiGraphics.m_280024_(hx, hy, hx + 30, hy + 30, -16777216, -13421773);
        }
        for (Bullet b : this.bullets) {
            int bx = gameX + (int)b.x;
            int by = gameY + (int)(b.y - this.cameraY);
            if (by < gameY - 5 || by > gameY + 215) continue;
            guiGraphics.m_280509_(bx, by, bx + 5, by + 5, -1);
        }
        if (!this.gameOver) {
            int px = gameX + (int)this.playerX;
            int py = gameY + (int)(this.playerY - this.cameraY);
            guiGraphics.m_280509_(px - 1, py - 1, px + 15 + 1, py + 15 + 1, -2013202506);
            guiGraphics.m_280024_(px, py, px + 15, py + 15, -16713802, 16758763);
        }
        guiGraphics.m_280430_(font, (Component)Component.m_237110_((String)"minygamez.game.score", (Object[])new Object[]{this.score}), bookX + 10, bookY - 20, 0xFFFFFF);
        guiGraphics.m_280430_(font, (Component)Component.m_237110_((String)"minygamez.game.last_score", (Object[])new Object[]{this.lastScore}), bookX + bookWidth - 100, bookY - 20, 0xFFFFFF);
        if (this.waitingForInput) {
            guiGraphics.m_280653_(font, (Component)Component.m_237115_((String)"minygamez.game.press_arrow"), centerX, centerY, 0xFFFFFF);
        } else if (this.gameOver) {
            guiGraphics.m_280653_(font, (Component)Component.m_237110_((String)"minygamez.game.game_over", (Object[])new Object[]{this.score}), centerX, centerY - 20, -43606);
            guiGraphics.m_280653_(font, (Component)Component.m_237115_((String)"minygamez.game.press_arrow"), centerX, centerY, 0xFFFFFF);
        }
    }

    private static class Platform {
        double x;
        double y;
        String type;
        boolean used;
        boolean visible;
        double speed;
        int disappearTimer;

        Platform(double x, double y, String type, double speed) {
            this.x = x;
            this.y = y;
            this.type = type;
            this.used = false;
            this.visible = true;
            this.speed = speed;
            this.disappearTimer = 0;
        }
    }

    private static class Enemy {
        double x;
        double y;
        int health;
        boolean fast;
        double speed;

        Enemy(double x, double y, boolean fast, double speed) {
            this.x = x;
            this.y = y;
            this.health = 1;
            this.fast = fast;
            this.speed = speed;
        }
    }

    private static class BlackHole {
        double x;
        double y;

        BlackHole(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }

    private static class Bullet {
        double x;
        double y;
        double vy;

        Bullet(double x, double y) {
            this.x = x;
            this.y = y;
            this.vy = -10.0;
        }
    }
}

