/*
 * Decompiled with CFR 0.152.
 */
package Gvoper.minygamez;

import Gvoper.minygamez.Scoreboard;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FlappyBird {
    private static final int GAME_WIDTH = 225;
    private static final int GAME_HEIGHT = 225;
    private static final int GROUND_Y = 200;
    private static final int GROUND_HEIGHT = 4;
    private static final int BIRD_SIZE = 15;
    private static final int PIPE_WIDTH = 30;
    private static final int PIPE_GAP = 70;
    private double birdX = 50.0;
    private double birdY = 100.0;
    private double birdVY = 0.0;
    private boolean waiting = true;
    private boolean gameOver = false;
    private boolean scoreSent = false;
    private int score = 0;
    private int lastScore = 0;
    private double pipeSpeed = -3.0;
    private final ArrayList<Pipe> pipes = new ArrayList();
    private int pipeTimer = 80;
    private final Random random = new Random();

    public void init() {
        this.birdX = 50.0;
        this.birdY = 100.0;
        this.birdVY = 0.0;
        this.waiting = true;
        this.gameOver = false;
        this.scoreSent = false;
        this.score = 0;
        this.pipeSpeed = -3.0;
        this.pipes.clear();
        this.pipeTimer = 80;
        this.lastScore = Scoreboard.getPlayerScore("FlappyBird", Minecraft.m_91087_().f_91074_.m_20148_());
    }

    public void tick() {
        if (this.waiting || this.gameOver) {
            return;
        }
        this.birdVY += 0.4;
        this.birdY += this.birdVY;
        if (this.birdY + 15.0 > 200.0 || this.birdY < 0.0) {
            this.gameOver = true;
        }
        ArrayList<Pipe> newPipes = new ArrayList<Pipe>();
        for (Pipe p : this.pipes) {
            p.x += this.pipeSpeed;
            if (!(p.x + 30.0 >= 0.0)) continue;
            newPipes.add(p);
            if (this.birdX + 15.0 > p.x && this.birdX < p.x + 30.0 && (this.birdY < (double)(p.gapY - 35) || this.birdY + 15.0 > (double)(p.gapY + 35))) {
                this.gameOver = true;
            }
            if (p.scored || !(p.x + 30.0 < this.birdX)) continue;
            ++this.score;
            p.scored = true;
        }
        this.pipes.clear();
        this.pipes.addAll(newPipes);
        --this.pipeTimer;
        if (this.pipeTimer <= 0) {
            int gapY = 50 + this.random.nextInt(100);
            this.pipes.add(new Pipe(255.0, gapY));
            this.pipeTimer = 80;
        }
        if (this.score % 10 == 0 && this.score > 0 && this.score % 2 == 0) {
            this.pipeSpeed = Math.max(-5.0, this.pipeSpeed - 0.2);
        }
        if (this.gameOver && !this.scoreSent) {
            Scoreboard.updateScore("FlappyBird", Minecraft.m_91087_().f_91074_.m_20148_(), this.score);
            this.scoreSent = true;
        }
    }

    public void handleKey(int keyCode) {
        if (keyCode != 32) {
            return;
        }
        if (this.waiting) {
            this.waiting = false;
            return;
        }
        if (this.gameOver) {
            this.init();
            this.waiting = false;
            return;
        }
        this.birdVY = -6.0;
    }

    public void mouseClicked(double mouseX, double mouseY, int bookX, int bookY, int button) {
        if (button != 0) {
            return;
        }
        if (this.waiting) {
            this.waiting = false;
            return;
        }
        if (this.gameOver) {
            this.init();
            this.waiting = false;
            return;
        }
        this.birdVY = -6.0;
    }

    public void render(GuiGraphics g, Font font, int x, int y, int w, int h, float partial) {
        g.m_280509_(x, y, x + 225, y + 225, -7876885);
        g.m_280509_(x - 1, y + 200 - 1, x + 225 + 1, y + 200 + 4 + 1, -2007673515);
        g.m_280509_(x, y + 200, x + 225, y + 200 + 4, -11184811);
        for (Pipe p : this.pipes) {
            int px = x + (int)p.x;
            g.m_280509_(px - 1, y - 1, px + 30 + 1, y + p.gapY - 35 + 1, -2011002078);
            g.m_280509_(px, y, px + 30, y + p.gapY - 35, -14513374);
            g.m_280509_(px - 1, y + p.gapY + 35 - 1, px + 30 + 1, y + 225 + 1, -2011002078);
            g.m_280509_(px, y + p.gapY + 35, px + 30, y + 225, -14513374);
        }
        if (!this.gameOver) {
            int bx = x + (int)this.birdX;
            int by = y + (int)this.birdY;
            g.m_280509_(bx - 1, by - 1, bx + 15 + 1, by + 15 + 1, -1996499200);
            g.m_280024_(bx, by, bx + 15, by + 15, -10496, -23296);
        }
        g.m_280430_(font, (Component)Component.m_237110_((String)"minygamez.game.score", (Object[])new Object[]{this.score}), x + 10, y - 20, 0xFFFFFF);
        g.m_280430_(font, (Component)Component.m_237110_((String)"minygamez.game.last_score", (Object[])new Object[]{this.lastScore}), x + w - 100, y - 20, 0xFFFFFF);
        if (this.waiting) {
            g.m_280653_(font, (Component)Component.m_237115_((String)"minygamez.game.press_space"), x + w / 2, y + h / 2, 0xFFFFFF);
        } else if (this.gameOver) {
            g.m_280653_(font, (Component)Component.m_237110_((String)"minygamez.game.game_over", (Object[])new Object[]{this.score}), x + w / 2, y + h / 2 - 20, -43606);
            g.m_280653_(font, (Component)Component.m_237115_((String)"minygamez.game.press_space"), x + w / 2, y + h / 2, 0xFFFFFF);
        }
    }

    private static class Pipe {
        double x;
        int gapY;
        boolean scored;

        Pipe(double x, int gapY) {
            this.x = x;
            this.gapY = gapY;
            this.scored = false;
        }
    }
}

