/*
 * Decompiled with CFR 0.152.
 */
package Gvoper.minygamez;

import Gvoper.minygamez.Scoreboard;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Reaction {
    private static final int GAME_WIDTH = 225;
    private static final int GAME_HEIGHT = 225;
    private static final int DOT_SIZE = 15;
    private double dotX;
    private double dotY;
    private int dotTimer;
    private double baseTime;
    private int clicks;
    private int misses;
    private int score;
    private boolean gameOver;
    private boolean waitingForInput;
    private boolean scoreSent;
    private int lastScore;
    private Random random = new Random();

    public void init() {
        this.dotX = 0.0;
        this.dotY = 0.0;
        this.dotTimer = 0;
        this.baseTime = 59.400000000000006;
        this.clicks = 0;
        this.misses = 0;
        this.score = 0;
        this.gameOver = false;
        this.waitingForInput = true;
        this.scoreSent = false;
        this.lastScore = Scoreboard.getPlayerScore("Reaction", Minecraft.m_91087_().f_91074_.m_20148_());
        this.spawnDot();
    }

    private void spawnDot() {
        this.dotX = this.random.nextDouble() * 210.0;
        this.dotY = this.random.nextDouble() * 210.0;
        this.dotTimer = (int)this.baseTime;
    }

    public void tick() {
        if (this.waitingForInput || this.gameOver) {
            return;
        }
        --this.dotTimer;
        if (this.dotTimer <= 0) {
            ++this.misses;
            if (this.misses >= 3) {
                this.gameOver = true;
                if (!this.scoreSent) {
                    Scoreboard.updateScore("Reaction", Minecraft.m_91087_().f_91074_.m_20148_(), this.score);
                    this.scoreSent = true;
                }
            } else {
                this.spawnDot();
            }
        }
    }

    public void handleKey(int keyCode) {
        if (this.waitingForInput) {
            if (keyCode == 32) {
                this.waitingForInput = false;
            }
            return;
        }
        if (this.gameOver && keyCode == 32) {
            this.init();
            this.waitingForInput = false;
        }
    }

    public void mouseClicked(double mouseX, double mouseY, int bookX, int bookY) {
        if (this.waitingForInput) {
            this.waitingForInput = false;
            return;
        }
        if (this.gameOver) {
            this.init();
            this.waitingForInput = false;
            return;
        }
        double mx = mouseX - (double)bookX;
        double my = mouseY - (double)bookY;
        if (mx >= this.dotX && mx < this.dotX + 15.0 && my >= this.dotY && my < this.dotY + 15.0) {
            ++this.score;
            ++this.clicks;
            if (this.clicks % 5 == 0) {
                this.baseTime *= 0.95;
            }
            this.spawnDot();
        }
    }

    public void render(GuiGraphics guiGraphics, Font font, int bookX, int bookY, int bookWidth, int bookHeight, float partialTicks) {
        int gameX = bookX;
        int gameY = bookY;
        if (this.dotTimer > 0 && !this.gameOver) {
            int size = this.dotTimer <= 10 ? (int)((double)(15 * this.dotTimer) / 10.0) : 15;
            int dx = gameX + (int)this.dotX + (15 - size) / 2;
            int dy = gameY + (int)this.dotY + (15 - size) / 2;
            if (size > 0) {
                guiGraphics.m_280509_(dx - 1, dy - 1, dx + size + 1, dy + size + 1, -1996554240);
                guiGraphics.m_280024_(dx, dy, dx + size, dy + size, -65536, -43691);
            }
        }
        for (int i = 0; i < this.misses; ++i) {
            int mx = gameX + 10 + i * 20;
            int my = gameY + 10;
            guiGraphics.m_280509_(mx, my, mx + 10, my + 10, -65536);
            guiGraphics.m_280509_(mx + 2, my + 2, mx + 8, my + 8, -16777216);
        }
        guiGraphics.m_280430_(font, (Component)Component.m_237110_((String)"minygamez.game.score", (Object[])new Object[]{this.score}), bookX + 10, bookY - 20, 0xFFFFFF);
        guiGraphics.m_280430_(font, (Component)Component.m_237110_((String)"minygamez.game.last_score", (Object[])new Object[]{this.lastScore}), bookX + bookWidth - 100, bookY - 20, 0xFFFFFF);
        if (this.waitingForInput) {
            guiGraphics.m_280653_(font, (Component)Component.m_237115_((String)"minygamez.game.press_space"), bookX + bookWidth / 2, bookY + bookHeight / 2, 0xFFFFFF);
        } else if (this.gameOver) {
            guiGraphics.m_280653_(font, (Component)Component.m_237110_((String)"minygamez.game.game_over", (Object[])new Object[]{this.score}), bookX + bookWidth / 2, bookY + bookHeight / 2 - 20, -43606);
            guiGraphics.m_280653_(font, (Component)Component.m_237115_((String)"minygamez.game.press_space"), bookX + bookWidth / 2, bookY + bookHeight / 2, 0xFFFFFF);
        }
    }
}

