/*
 * Decompiled with CFR 0.152.
 */
package Gvoper.minygamez;

import Gvoper.minygamez.Meny;
import Gvoper.minygamez.Start;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class Scoreboard
extends Screen {
    private static final Map<String, Map<UUID, Integer>> highScores = new HashMap<String, Map<UUID, Integer>>();
    private static final String DATA_FILE = "minygamez_scores.dat";
    private static final byte[] XOR_KEY = "minygamez_key".getBytes(StandardCharsets.UTF_8);
    private static final int BOOK_WIDTH = 400;
    private static final int BOOK_HEIGHT = 360;
    private static final int TITLE_Y_OFFSET = 20;
    private static final int GAME_Y_SPACING = 20;
    private static final int SCORE_Y_SPACING = 12;
    private int scrollOffset = 0;
    private int maxScroll;

    public Scoreboard() {
        super((Component)Component.m_237115_((String)"minygamez.scoreboard.title"));
        if (Minecraft.m_91087_().m_91090_() || Minecraft.m_91087_().m_91403_() != null) {
            this.requestScores();
        }
    }

    private void requestScores() {
        Start.NETWORK.sendToServer((Object)new ScoreRequestPacket());
    }

    public static void updateScore(String game, UUID player, int score) {
        Start.NETWORK.sendToServer((Object)new ScorePacket(game, player, score));
    }

    public static int getPlayerScore(String game, UUID player) {
        return ((Map)highScores.getOrDefault(game, new HashMap())).getOrDefault(player, 0);
    }

    protected void m_7856_() {
        int contentHeight = 50;
        for (String game : highScores.keySet()) {
            contentHeight += 95;
        }
        this.maxScroll = Math.max(0, contentHeight - 360 + 20);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int bookX = (this.f_96543_ - 400) / 2;
        int bookY = (this.f_96544_ - 360) / 2;
        guiGraphics.m_280509_(bookX - 5, bookY - 5, bookX + 400 + 5, bookY + 360 + 5, 0x22000000);
        guiGraphics.m_280024_(bookX, bookY, bookX + 400, bookY + 360, -14932699, -13877680);
        guiGraphics.m_280588_(bookX, bookY, bookX + 400, bookY + 360);
        int titleWidth = this.f_96547_.m_92852_((FormattedText)this.f_96539_);
        int titleX = bookX + (400 - titleWidth) / 2;
        int titleY = bookY + 20 - this.scrollOffset;
        guiGraphics.m_280509_(titleX - 5, titleY - 2, titleX + titleWidth + 5, titleY + 10, -2013265920);
        guiGraphics.m_280430_(this.f_96547_, this.f_96539_, titleX + 1, titleY + 1, 0x22000000);
        guiGraphics.m_280430_(this.f_96547_, this.f_96539_, titleX, titleY, 0xFFFFFF);
        int y = bookY + 20 + 30 - this.scrollOffset;
        for (String game : highScores.keySet()) {
            guiGraphics.m_280024_(bookX + 10, y - 2, bookX + 400 - 10, y - 1, -16713802, 16758763);
            guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)("minygamez.game." + game.toLowerCase())), bookX + 15, y, 0xFFFFFF);
            y += 15;
            List scores = highScores.get(game).entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(5L).collect(Collectors.toList());
            int place = 1;
            int playerPlace = -1;
            int playerScore = Scoreboard.getPlayerScore(game, Minecraft.m_91087_().f_91074_.m_20148_());
            int totalPlayers = highScores.get(game).size();
            for (int i = 0; i < highScores.get(game).size(); ++i) {
                Map.Entry entry = highScores.get(game).entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).skip(i).findFirst().orElse(null);
                if (entry == null || !((UUID)entry.getKey()).equals(Minecraft.m_91087_().f_91074_.m_20148_())) continue;
                playerPlace = i + 1;
            }
            for (Map.Entry entry : scores) {
                String name = Minecraft.m_91087_().m_91403_() != null && Minecraft.m_91087_().m_91403_().m_104949_((UUID)entry.getKey()) != null ? Minecraft.m_91087_().m_91403_().m_104949_((UUID)entry.getKey()).m_105312_().getName() : ((UUID)entry.getKey()).toString().substring(0, 8);
                String scoreText = place + ". " + name + ": " + String.valueOf(entry.getValue());
                guiGraphics.m_280488_(this.f_96547_, scoreText, bookX + 25, y, 0xFFFFFF);
                y += 12;
                ++place;
            }
            if (playerScore > 0) {
                guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"minygamez.scoreboard.place", (Object[])new Object[]{playerPlace, totalPlayers, playerScore}), bookX + 15, y, -43606);
                y += 12;
            }
            y += 20;
        }
        guiGraphics.m_280618_();
        if (this.maxScroll > 0) {
            int scrollBarX = bookX + 400 - 5;
            int scrollBarHeight = (int)(360.0f / (float)(360 + this.maxScroll) * 360.0f);
            int scrollBarY = bookY + (int)((float)this.scrollOffset / (float)this.maxScroll * (float)(360 - scrollBarHeight));
            guiGraphics.m_280509_(scrollBarX, scrollBarY, scrollBarX + 5, scrollBarY + scrollBarHeight, -16713802);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta != 0.0) {
            this.scrollOffset = (int)((double)this.scrollOffset - delta * 20.0);
            this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScroll));
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.f_96541_.m_91152_((Screen)new Meny());
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private static void saveServerScores(MinecraftServer server) {
        try {
            File file = new File(server.m_129843_(LevelResource.f_78182_).toFile(), DATA_FILE);
            CompoundTag tag = new CompoundTag();
            for (String game : highScores.keySet()) {
                CompoundTag gameTag = new CompoundTag();
                for (Map.Entry<UUID, Integer> entry : highScores.get(game).entrySet()) {
                    gameTag.m_128405_(entry.getKey().toString(), entry.getValue().intValue());
                }
                tag.m_128365_(game, (Tag)gameTag);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            NbtIo.m_128941_((CompoundTag)tag, (DataOutput)new DataOutputStream(baos));
            byte[] data = baos.toByteArray();
            byte[] encrypted = Scoreboard.xorEncrypt(data);
            CompoundTag encryptedTag = new CompoundTag();
            encryptedTag.m_128382_("scores", encrypted);
            NbtIo.m_128947_((CompoundTag)encryptedTag, (OutputStream)new FileOutputStream(file));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void loadServerScores(MinecraftServer server) {
        try {
            File file = new File(server.m_129843_(LevelResource.f_78182_).toFile(), DATA_FILE);
            if (file.exists()) {
                CompoundTag tag = NbtIo.m_128937_((File)file);
                byte[] encrypted = tag.m_128463_("scores");
                byte[] decrypted = Scoreboard.xorDecrypt(encrypted);
                CompoundTag scoresTag = NbtIo.m_128928_((DataInput)new DataInputStream(new ByteArrayInputStream(decrypted)));
                for (String game : scoresTag.m_128431_()) {
                    CompoundTag gameTag = scoresTag.m_128469_(game);
                    HashMap<UUID, Integer> gameScores = new HashMap<UUID, Integer>();
                    for (String uuid : gameTag.m_128431_()) {
                        gameScores.put(UUID.fromString(uuid), gameTag.m_128451_(uuid));
                    }
                    highScores.put(game, gameScores);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static byte[] xorEncrypt(byte[] data) {
        byte[] result = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = (byte)(data[i] ^ XOR_KEY[i % XOR_KEY.length]);
        }
        return result;
    }

    private static byte[] xorDecrypt(byte[] data) {
        return Scoreboard.xorEncrypt(data);
    }

    public static class ScoreRequestPacket {
        public void encode(FriendlyByteBuf buf) {
        }

        public static ScoreRequestPacket decode(FriendlyByteBuf buf) {
            return new ScoreRequestPacket();
        }

        public static void handle(ScoreRequestPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getSender() != null) {
                    CompoundTag tag = new CompoundTag();
                    for (String game : highScores.keySet()) {
                        CompoundTag gameTag = new CompoundTag();
                        for (Map.Entry<UUID, Integer> entry : highScores.get(game).entrySet()) {
                            gameTag.m_128405_(entry.getKey().toString(), entry.getValue().intValue());
                        }
                        tag.m_128365_(game, (Tag)gameTag);
                    }
                    Start.NETWORK.send(PacketDistributor.PLAYER.with(() -> ScoreRequestPacket.lambda$handle$0((Supplier)ctx)), (Object)new ScoreSyncPacket(tag));
                }
            });
            ctx.get().setPacketHandled(true);
        }

        private static /* synthetic */ ServerPlayer lambda$handle$0(Supplier ctx) {
            return ((NetworkEvent.Context)ctx.get()).getSender();
        }
    }

    public static class ScorePacket {
        private final String game;
        private final UUID player;
        private final int score;

        public ScorePacket(String game, UUID player, int score) {
            this.game = game;
            this.player = player;
            this.score = score;
        }

        public void encode(FriendlyByteBuf buf) {
            buf.m_130072_(this.game, Short.MAX_VALUE);
            buf.m_130077_(this.player);
            buf.writeInt(this.score);
        }

        public static ScorePacket decode(FriendlyByteBuf buf) {
            return new ScorePacket(buf.m_130136_(Short.MAX_VALUE), buf.m_130259_(), buf.readInt());
        }

        public static void handle(ScorePacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Map gameScores = highScores.computeIfAbsent(msg.game, k -> new HashMap());
                int currentScore = gameScores.getOrDefault(msg.player, 0);
                if (msg.score > currentScore) {
                    gameScores.put(msg.player, msg.score);
                    if (((NetworkEvent.Context)ctx.get()).getSender() != null) {
                        Scoreboard.saveServerScores(((NetworkEvent.Context)ctx.get()).getSender().m_20194_());
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    @Mod.EventBusSubscriber(modid="minygamez", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerEvents {
        @SubscribeEvent
        public static void onLevelSave(LevelEvent.Save event) {
            if (event.getLevel() instanceof ServerLevel) {
                Scoreboard.saveServerScores(event.getLevel().m_7654_());
            }
        }

        @SubscribeEvent
        public static void onLevelLoad(LevelEvent.Load event) {
            if (event.getLevel() instanceof ServerLevel) {
                Scoreboard.loadServerScores(event.getLevel().m_7654_());
            }
        }
    }

    public static class ScoreSyncPacket {
        private final CompoundTag scores;

        public ScoreSyncPacket(CompoundTag scores) {
            this.scores = scores;
        }

        public void encode(FriendlyByteBuf buf) {
            buf.m_130079_(this.scores);
        }

        public static ScoreSyncPacket decode(FriendlyByteBuf buf) {
            return new ScoreSyncPacket(buf.m_130260_());
        }

        public static void handle(ScoreSyncPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                highScores.clear();
                for (String game : msg.scores.m_128431_()) {
                    CompoundTag gameTag = msg.scores.m_128469_(game);
                    HashMap<UUID, Integer> gameScores = new HashMap<UUID, Integer>();
                    for (String uuid : gameTag.m_128431_()) {
                        gameScores.put(UUID.fromString(uuid), gameTag.m_128451_(uuid));
                    }
                    highScores.put(game, gameScores);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

