/*
 * Decompiled with CFR 0.152.
 */
package Gvoper.minygamez;

import Gvoper.minygamez.Scoreboard;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Snake {
    private ArrayList<int[]> snake;
    private int[] food;
    private int direction;
    private int score;
    private boolean gameOver;
    private boolean waitingForInput;
    private int updateTicks;
    private boolean scoreSent;
    private static final int GRID_SIZE = 15;
    private static final int GRID_WIDTH = 15;
    private static final int GRID_HEIGHT = 15;
    private static final int TICKS_PER_UPDATE = 2;
    private static final int GAME_WIDTH = 225;
    private static final int GAME_HEIGHT = 225;
    private Random random = new Random();
    private int lastScore;
    private Deque<Integer> inputQueue;

    public void init() {
        this.snake = new ArrayList();
        this.snake.add(new int[]{7, 7});
        this.direction = -1;
        this.score = 0;
        this.gameOver = false;
        this.waitingForInput = true;
        this.updateTicks = 0;
        this.scoreSent = false;
        this.inputQueue = new LinkedList<Integer>();
        this.lastScore = Scoreboard.getPlayerScore("Snake", Minecraft.m_91087_().f_91074_.m_20148_());
        this.spawnFood();
    }

    private void spawnFood() {
        do {
            this.food = new int[]{this.random.nextInt(15), this.random.nextInt(15)};
        } while (this.snake.stream().anyMatch(s -> s[0] == this.food[0] && s[1] == this.food[1]));
    }

    public void tick() {
        if (this.waitingForInput) {
            return;
        }
        if (this.gameOver) {
            return;
        }
        ++this.updateTicks;
        if (this.updateTicks >= 2) {
            this.updateTicks = 0;
            if (!this.inputQueue.isEmpty()) {
                int newDirection = this.inputQueue.poll();
                if (this.snake.size() <= 1 || !this.isOppositeDirection(newDirection, this.direction)) {
                    this.direction = newDirection;
                }
            }
            if (this.direction == -1) {
                return;
            }
            int[] head = (int[])this.snake.get(0).clone();
            switch (this.direction) {
                case 0: {
                    head[1] = head[1] - 1;
                    break;
                }
                case 1: {
                    head[0] = head[0] + 1;
                    break;
                }
                case 2: {
                    head[1] = head[1] + 1;
                    break;
                }
                case 3: {
                    head[0] = head[0] - 1;
                }
            }
            if (head[0] < 0 || head[0] >= 15 || head[1] < 0 || head[1] >= 15 || this.snake.stream().anyMatch(s -> s[0] == head[0] && s[1] == head[1])) {
                this.gameOver = true;
                if (!this.scoreSent) {
                    Scoreboard.updateScore("Snake", Minecraft.m_91087_().f_91074_.m_20148_(), this.score);
                    this.scoreSent = true;
                }
                return;
            }
            this.snake.add(0, head);
            if (head[0] == this.food[0] && head[1] == this.food[1]) {
                ++this.score;
                this.spawnFood();
            } else {
                this.snake.remove(this.snake.size() - 1);
            }
        }
    }

    private boolean isOppositeDirection(int newDir, int currentDir) {
        return newDir == 0 && currentDir == 2 || newDir == 2 && currentDir == 0 || newDir == 1 && currentDir == 3 || newDir == 3 && currentDir == 1;
    }

    public void handleKey(int keyCode) {
        int newDirection;
        if (this.gameOver && this.isArrowKey(keyCode)) {
            this.init();
            this.direction = this.getDirectionFromKey(keyCode);
            this.waitingForInput = false;
            this.inputQueue.clear();
            return;
        }
        if (this.waitingForInput || this.gameOver) {
            if (this.waitingForInput && this.isArrowKey(keyCode)) {
                this.direction = this.getDirectionFromKey(keyCode);
                this.waitingForInput = false;
            }
            return;
        }
        if (this.isArrowKey(keyCode) && !this.inputQueue.contains(newDirection = this.getDirectionFromKey(keyCode))) {
            this.inputQueue.offer(newDirection);
        }
    }

    private boolean isArrowKey(int keyCode) {
        return keyCode == 265 || keyCode == 262 || keyCode == 264 || keyCode == 263;
    }

    private int getDirectionFromKey(int keyCode) {
        switch (keyCode) {
            case 265: {
                return 0;
            }
            case 262: {
                return 1;
            }
            case 264: {
                return 2;
            }
            case 263: {
                return 3;
            }
        }
        return -1;
    }

    public boolean isGameOver() {
        return this.gameOver;
    }

    public void render(GuiGraphics guiGraphics, Font font, int bookX, int bookY, int bookWidth, int bookHeight, float partialTicks) {
        int gameX = bookX + (bookWidth - 225) / 2;
        int gameY = bookY + (bookHeight - 225) / 2;
        int centerX = bookX + bookWidth / 2;
        int centerY = bookY + bookHeight / 2;
        for (int x = 0; x < 15; ++x) {
            for (int y = 0; y < 15; ++y) {
                int cellX = gameX + x * 15;
                int cellY = gameY + y * 15;
                guiGraphics.m_280509_(cellX - 1, cellY - 1, cellX + 15 + 1, cellY + 15 + 1, 0x22000000);
                guiGraphics.m_280024_(cellX, cellY, cellX + 15, cellY + 15, -14932699, -13877680);
            }
        }
        for (int i = 0; i < this.snake.size(); ++i) {
            int[] segment = this.snake.get(i);
            float t = (float)i / (float)this.snake.size();
            int r = (int)(0.0f + 0.0f * t);
            int g = (int)(247.0f + -64.0f * t);
            int b = (int)(182.0f + 53.0f * t);
            int color = 0xFF000000 | r << 16 | g << 8 | b;
            int segX = gameX + segment[0] * 15 + 1;
            int segY = gameY + segment[1] * 15 + 1;
            guiGraphics.m_280509_(segX, segY, segX + 15 - 2, segY + 15 - 2, color);
            guiGraphics.m_280509_(segX - 1, segY - 1, segX + 15 - 1, segY + 15 - 1, 570488758);
        }
        int pointSize = 12;
        int pointX = gameX + this.food[0] * 15 + (15 - pointSize) / 2;
        int pointY = gameY + this.food[1] * 15 + (15 - pointSize) / 2;
        guiGraphics.m_280509_(pointX - 1, pointY - 1, pointX + pointSize + 1, pointY + pointSize + 1, -1996553985);
        guiGraphics.m_280509_(pointX, pointY, pointX + pointSize, pointY + pointSize, -43606);
        guiGraphics.m_280430_(font, (Component)Component.m_237110_((String)"minygamez.game.score", (Object[])new Object[]{this.score}), bookX + 20, bookY - 19, 0xFFFFFF);
        guiGraphics.m_280430_(font, (Component)Component.m_237110_((String)"minygamez.game.last_score", (Object[])new Object[]{this.lastScore}), bookX + bookWidth - 100, bookY - 19, 0xFFFFFF);
        if (this.waitingForInput) {
            guiGraphics.m_280653_(font, (Component)Component.m_237115_((String)"minygamez.game.press_arrow"), centerX, centerY, 0xFFFFFF);
        } else if (this.gameOver) {
            guiGraphics.m_280653_(font, (Component)Component.m_237110_((String)"minygamez.game.game_over", (Object[])new Object[]{this.score}), centerX, centerY - 20, 0xFFFFFF);
            guiGraphics.m_280653_(font, (Component)Component.m_237115_((String)"minygamez.game.press_arrow"), centerX, centerY, 0xFFFFFF);
        }
    }
}

