/*
 * Decompiled with CFR 0.152.
 */
package Gvoper.minygamez;

import Gvoper.minygamez.Scoreboard;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Tetris {
    private static final int GRID_WIDTH = 10;
    private static final int GRID_HEIGHT = 15;
    private static final int GRID_SIZE = 15;
    private static final int GAME_WIDTH = 150;
    private static final int GAME_HEIGHT = 225;
    private static final int PREVIEW_SIZE = 60;
    private int[][] grid;
    private Tetromino currentPiece;
    private Tetromino nextPiece;
    private int pieceX;
    private int pieceY;
    private int score;
    private boolean gameOver;
    private boolean waitingForInput;
    private int updateTicks;
    private int ticksPerUpdate;
    private boolean scoreSent;
    private int lastScore;
    private Random random = new Random();
    private static final int[][][] SHAPES = new int[][][]{new int[][]{{1, 1, 1, 1}}, new int[][]{{1, 1}, {1, 1}}, new int[][]{{0, 1, 0}, {1, 1, 1}}, new int[][]{{0, 1, 1}, {1, 1, 0}}, new int[][]{{1, 1, 0}, {0, 1, 1}}, new int[][]{{1, 0, 0}, {1, 1, 1}}, new int[][]{{0, 0, 1}, {1, 1, 1}}};
    private static final int[][] SHAPE_COLORS = new int[][]{{-16713802, 16758763}, {-43606, -43606}, {-5635841, -2271745}, {-65536, -43691}, {-16711936, -11141291}, {-16776961, -11184641}, {-22016, -8875}};

    public void init() {
        this.grid = new int[15][10];
        this.score = 0;
        this.gameOver = false;
        this.waitingForInput = true;
        this.updateTicks = 0;
        this.ticksPerUpdate = 20;
        this.scoreSent = false;
        this.lastScore = Scoreboard.getPlayerScore("Tetris", Minecraft.m_91087_().f_91074_.m_20148_());
        this.spawnPiece();
    }

    private void spawnPiece() {
        int type;
        if (this.nextPiece == null) {
            type = this.random.nextInt(SHAPES.length);
            this.nextPiece = new Tetromino(this.cloneShape(SHAPES[type]), SHAPE_COLORS[type]);
        }
        this.currentPiece = this.nextPiece;
        type = this.random.nextInt(SHAPES.length);
        this.nextPiece = new Tetromino(this.cloneShape(SHAPES[type]), SHAPE_COLORS[type]);
        this.pieceX = 5 - this.currentPiece.shape[0].length / 2;
        this.pieceY = 0;
        if (!this.isValidPosition(this.pieceX, this.pieceY, this.currentPiece.shape)) {
            this.gameOver = true;
            if (!this.scoreSent) {
                Scoreboard.updateScore("Tetris", Minecraft.m_91087_().f_91074_.m_20148_(), this.score);
                this.scoreSent = true;
            }
        }
    }

    private int[][] cloneShape(int[][] shape) {
        int[][] newShape = new int[shape.length][shape[0].length];
        for (int y = 0; y < shape.length; ++y) {
            System.arraycopy(shape[y], 0, newShape[y], 0, shape[y].length);
        }
        return newShape;
    }

    public void tick() {
        if (this.waitingForInput || this.gameOver) {
            return;
        }
        ++this.updateTicks;
        if (this.updateTicks >= this.ticksPerUpdate) {
            this.updateTicks = 0;
            if (this.isValidPosition(this.pieceX, this.pieceY + 1, this.currentPiece.shape)) {
                ++this.pieceY;
            } else {
                this.placePiece();
                this.clearLines();
                this.spawnPiece();
                this.ticksPerUpdate = Math.max(5, 20 - this.score / 1000);
            }
        }
    }

    private void placePiece() {
        for (int y = 0; y < this.currentPiece.shape.length; ++y) {
            for (int x = 0; x < this.currentPiece.shape[y].length; ++x) {
                if (this.currentPiece.shape[y][x] == 0) continue;
                this.grid[this.pieceY + y][this.pieceX + x] = this.currentPiece.color[0];
            }
        }
    }

    private void clearLines() {
        int linesCleared = 0;
        for (int y = 14; y >= 0; --y) {
            int x;
            boolean full = true;
            for (x = 0; x < 10; ++x) {
                if (this.grid[y][x] != 0) continue;
                full = false;
                break;
            }
            if (!full) continue;
            ++linesCleared;
            for (int yy = y; yy > 0; --yy) {
                System.arraycopy(this.grid[yy - 1], 0, this.grid[yy], 0, 10);
            }
            for (x = 0; x < 10; ++x) {
                this.grid[0][x] = 0;
            }
            ++y;
        }
        this.score += linesCleared * 100;
    }

    private boolean isValidPosition(int x, int y, int[][] shape) {
        for (int sy = 0; sy < shape.length; ++sy) {
            for (int sx = 0; sx < shape[sy].length; ++sx) {
                if (shape[sy][sx] == 0) continue;
                int gx = x + sx;
                int gy = y + sy;
                if (gx >= 0 && gx < 10 && gy < 15 && (gy < 0 || this.grid[gy][gx] == 0)) continue;
                return false;
            }
        }
        return true;
    }

    public void handleKey(int keyCode) {
        if (this.waitingForInput) {
            if (this.isArrowKey(keyCode)) {
                this.waitingForInput = false;
            }
            return;
        }
        if (this.gameOver) {
            if (this.isArrowKey(keyCode)) {
                this.init();
                this.waitingForInput = false;
            }
            return;
        }
        if (keyCode == 263) {
            if (this.isValidPosition(this.pieceX - 1, this.pieceY, this.currentPiece.shape)) {
                --this.pieceX;
            }
        } else if (keyCode == 262) {
            if (this.isValidPosition(this.pieceX + 1, this.pieceY, this.currentPiece.shape)) {
                ++this.pieceX;
            }
        } else if (keyCode == 264) {
            if (this.isValidPosition(this.pieceX, this.pieceY + 1, this.currentPiece.shape)) {
                ++this.pieceY;
                this.updateTicks = 0;
            }
        } else if (keyCode == 265) {
            int[][] rotated = this.rotateShape(this.currentPiece.shape);
            if (this.isValidPosition(this.pieceX, this.pieceY, rotated)) {
                this.currentPiece.shape = rotated;
            }
        } else if (keyCode == 32) {
            while (this.isValidPosition(this.pieceX, this.pieceY + 1, this.currentPiece.shape)) {
                ++this.pieceY;
            }
            this.placePiece();
            this.clearLines();
            this.spawnPiece();
            this.updateTicks = 0;
        }
    }

    private int[][] rotateShape(int[][] shape) {
        int[][] rotated = new int[shape[0].length][shape.length];
        for (int y = 0; y < shape.length; ++y) {
            for (int x = 0; x < shape[y].length; ++x) {
                rotated[x][shape.length - 1 - y] = shape[y][x];
            }
        }
        return rotated;
    }

    private boolean isArrowKey(int keyCode) {
        return keyCode == 265 || keyCode == 262 || keyCode == 264 || keyCode == 263;
    }

    public boolean isGameOver() {
        return this.gameOver;
    }

    public void render(GuiGraphics guiGraphics, Font font, int bookX, int bookY, int bookWidth, int bookHeight, float partialTicks) {
        int x;
        int y;
        int cellY;
        int cellX;
        int gameX = bookX + (bookWidth - 150) / 2;
        int gameY = bookY;
        int centerX = bookX + bookWidth / 2;
        int centerY = bookY + bookHeight / 2;
        int previewX = gameX + 150 + 15;
        int previewY = gameY + 30;
        for (int x2 = 0; x2 < 10; ++x2) {
            for (int y2 = 0; y2 < 15; ++y2) {
                cellX = gameX + x2 * 15;
                cellY = gameY + y2 * 15;
                guiGraphics.m_280509_(cellX - 1, cellY - 1, cellX + 15 + 1, cellY + 15 + 1, 0x22000000);
                guiGraphics.m_280024_(cellX, cellY, cellX + 15, cellY + 15, -14932699, -13877680);
                if (this.grid[y2][x2] == 0) continue;
                guiGraphics.m_280509_(cellX + 1, cellY + 1, cellX + 15 - 1, cellY + 15 - 1, -2013265920);
                guiGraphics.m_280509_(cellX + 2, cellY + 2, cellX + 15 - 2, cellY + 15 - 2, this.grid[y2][x2]);
            }
        }
        if (!this.waitingForInput && !this.gameOver) {
            for (y = 0; y < this.currentPiece.shape.length; ++y) {
                for (x = 0; x < this.currentPiece.shape[y].length; ++x) {
                    if (this.currentPiece.shape[y][x] == 0) continue;
                    cellX = gameX + (this.pieceX + x) * 15;
                    cellY = gameY + (this.pieceY + y) * 15;
                    guiGraphics.m_280509_(cellX + 1, cellY + 1, cellX + 15 - 1, cellY + 15 - 1, -2013265920);
                    guiGraphics.m_280024_(cellX + 2, cellY + 2, cellX + 15 - 2, cellY + 15 - 2, this.currentPiece.color[0], this.currentPiece.color[1]);
                }
            }
        }
        guiGraphics.m_280024_(previewX - 5, previewY - 5, previewX + 60 + 5, previewY + 60 + 5, -14932699, -13877680);
        for (y = 0; y < this.nextPiece.shape.length; ++y) {
            for (x = 0; x < this.nextPiece.shape[y].length; ++x) {
                if (this.nextPiece.shape[y][x] == 0) continue;
                cellX = previewX + x * 15;
                cellY = previewY + y * 15;
                guiGraphics.m_280509_(cellX + 1, cellY + 1, cellX + 15 - 1, cellY + 15 - 1, -2013265920);
                guiGraphics.m_280024_(cellX + 2, cellY + 2, cellX + 15 - 2, cellY + 15 - 2, this.nextPiece.color[0], this.nextPiece.color[1]);
            }
        }
        guiGraphics.m_280430_(font, (Component)Component.m_237110_((String)"minygamez.game.score", (Object[])new Object[]{this.score}), bookX + 10, bookY - 20, 0xFFFFFF);
        guiGraphics.m_280430_(font, (Component)Component.m_237110_((String)"minygamez.game.last_score", (Object[])new Object[]{this.lastScore}), bookX + bookWidth - 100, bookY - 20, 0xFFFFFF);
        if (this.waitingForInput) {
            guiGraphics.m_280653_(font, (Component)Component.m_237115_((String)"minygamez.game.press_arrow"), centerX, centerY, 0xFFFFFF);
        } else if (this.gameOver) {
            guiGraphics.m_280653_(font, (Component)Component.m_237110_((String)"minygamez.game.game_over", (Object[])new Object[]{this.score}), centerX, centerY - 20, -43606);
            guiGraphics.m_280653_(font, (Component)Component.m_237115_((String)"minygamez.game.press_arrow"), centerX, centerY, 0xFFFFFF);
        }
    }

    private static class Tetromino {
        int[][] shape;
        int[] color;

        Tetromino(int[][] shape, int[] color) {
            this.shape = shape;
            this.color = color;
        }
    }
}

