/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.myosotis.advancement.criterion.death.falling;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class DeathByFallingCriterion
extends SimpleCriterionTrigger<Conditions> {
    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public void trigger(ServerPlayer player, DamageSource damageSource) {
        LootContext lootcontext = DeathByFallingCriterion.createAdvancementEntityLootContext(player, damageSource);
        this.trigger(player, conditions -> conditions.test(lootcontext));
    }

    public static LootContext createAdvancementEntityLootContext(ServerPlayer player, DamageSource damageSource) {
        LootParams lootWorldContext = new LootParams.Builder(player.level()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)damageSource).withParameter(LootContextParams.ORIGIN, (Object)player.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)player).create(LootContextParamSets.ENTITY);
        return new LootContext.Builder(lootWorldContext).create(Optional.empty());
    }

    public record Conditions(Optional<ContextAwarePredicate> player) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Conditions::player)).apply((Applicative)instance, Conditions::new));

        public boolean test(LootContext context) {
            DamageSource damageSource = (DamageSource)context.getOptionalParameter(LootContextParams.DAMAGE_SOURCE);
            assert (damageSource != null);
            return damageSource.is(DamageTypes.FALL);
        }

        public void validate(CriterionValidator validator) {
            super.validate(validator);
        }
    }
}

