/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.myosotis.mixin.server.world;

import com.github.cao.awa.myosotis.death.type.explosion.PlayerDeathByExplosion;
import com.github.cao.awa.myosotis.death.type.fall.PlayerDeathByFalling;
import com.github.cao.awa.myosotis.death.type.fly.PlayerDeathByFlyIntoWall;
import com.github.cao.awa.myosotis.death.type.mob.skeleton.PlayerDeathBySkeleton;
import com.github.cao.awa.myosotis.death.type.mob.spider.PlayerDeathBySpider;
import com.github.cao.awa.myosotis.death.type.mob.wolf.PlayerDeathByWolf;
import com.github.cao.awa.myosotis.death.type.mob.zombie.PlayerDeathByZombie;
import com.github.cao.awa.myosotis.server.MyosotisServer;
import com.github.cao.awa.myosotis.server.world.session.ServerWorldSessionAccessor;
import com.github.cao.awa.myosotis.util.data.PlayerDeathDataUtil;
import com.github.cao.awa.myosotis.util.mob.DeathByMobUtil;
import java.util.List;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public class ServerWorldMixin
implements ServerWorldSessionAccessor {
    @Unique
    public LevelStorageSource.LevelStorageAccess myosotis$session;

    @Inject(method={"<init>(Lnet/minecraft/server/MinecraftServer;Ljava/util/concurrent/Executor;Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;Lnet/minecraft/world/level/storage/ServerLevelData;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/world/level/dimension/LevelStem;ZJLjava/util/List;ZLnet/minecraft/world/RandomSequences;)V"}, at={@At(value="RETURN")})
    public void onServerInit(MinecraftServer server, Executor workerExecutor, LevelStorageSource.LevelStorageAccess session, ServerLevelData properties, ResourceKey<Level> worldKey, LevelStem dimensionOptions, boolean debugWorld, long seed, List<CustomSpawner> spawners, boolean shouldTickTime, RandomSequences randomSequenceState, CallbackInfo ci) {
        this.myosotis$session = session;
    }

    @Inject(method={"addRespawnedPlayer(Lnet/minecraft/server/level/ServerPlayer;)V"}, at={@At(value="HEAD")})
    public void onPlayerRespawned(ServerPlayer player, CallbackInfo ci) {
        DamageSource damageSource = MyosotisServer.deaths.get(player.getPlainTextName());
        if (damageSource != null) {
            Skeleton skeleton;
            Creeper creeper;
            Entity entity;
            if (damageSource.is(DamageTypes.FALL) && PlayerDeathDataUtil.isFirstDeathBy(player, damageSource)) {
                PlayerDeathByFalling.tryRespawnWithFeather(player);
            }
            if (damageSource.is(DamageTypes.PLAYER_EXPLOSION) && (entity = damageSource.getEntity()) instanceof Creeper && PlayerDeathDataUtil.isFirstDeathBy(player, damageSource, (Mob)(creeper = (Creeper)entity))) {
                PlayerDeathByExplosion.tryRespawnWithFirework(player);
            }
            if (damageSource.is(DamageTypes.MOB_ATTACK)) {
                Spider spider;
                Wolf wolf;
                Zombie zombie;
                entity = damageSource.getEntity();
                if (entity instanceof Zombie && DeathByMobUtil.isFirstDeathBy(player, damageSource, (Mob)(zombie = (Zombie)entity))) {
                    PlayerDeathByZombie.tryRespawnWithWoodenSword(player);
                }
                if ((entity = damageSource.getEntity()) instanceof Wolf && DeathByMobUtil.isFirstDeathBy(player, damageSource, (Mob)(wolf = (Wolf)entity))) {
                    PlayerDeathByWolf.tryRespawnWithBones(player);
                }
                if ((entity = damageSource.getEntity()) instanceof Spider && DeathByMobUtil.isFirstDeathBy(player, damageSource, (Mob)(spider = (Spider)entity))) {
                    PlayerDeathBySpider.tryRespawnWithString(player);
                }
            }
            if (damageSource.is(DamageTypes.ARROW) && (entity = damageSource.getEntity()) instanceof Skeleton && DeathByMobUtil.isFirstDeathBy(player, damageSource, (Mob)(skeleton = (Skeleton)entity))) {
                PlayerDeathBySkeleton.tryRespawnWithSecurity(player);
            }
            if (damageSource.is(DamageTypes.FLY_INTO_WALL) && PlayerDeathDataUtil.isFirstDeathBy(player, damageSource)) {
                PlayerDeathByFlyIntoWall.tryRespawnWithRocket(player);
            }
            MyosotisServer.deaths.remove(player.getPlainTextName());
        }
    }

    @Override
    public LevelStorageSource.LevelStorageAccess myosotis$getSession() {
        return this.myosotis$session;
    }
}

