/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.myosotis.util.mob;

import com.github.cao.awa.myosotis.util.data.PlayerDeathDataUtil;
import com.github.cao.awa.sinuatum.function.exception.consumer.ExceptingConsumer;
import com.github.cao.awa.sinuatum.manipulate.Manipulate;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.Serializable;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;

public class DeathByMobUtil {
    private static final Map<Class<? extends Mob>, String> MOB_DEATH_COUNT_MAP = (Map)Manipulate.make((Object)new Object2ObjectOpenHashMap(), (ExceptingConsumer & Serializable)map -> {
        map.put(Zombie.class, (Object)"zombie");
        map.put(Skeleton.class, (Object)"skeleton");
        map.put(Wolf.class, (Object)"wolf");
        map.put(Spider.class, (Object)"spider");
    });

    public static int getDeathCount(ServerPlayer player, DamageSource damageSource, Mob mob) {
        return PlayerDeathDataUtil.getPlayerDeathCount(player, DeathByMobUtil.getDeathCountName(damageSource, mob));
    }

    public static String getDeathCountName(DamageSource damageSource, Mob mob) {
        return damageSource.getMsgId() + "_" + MOB_DEATH_COUNT_MAP.get(mob.getClass());
    }

    public static boolean isFirstDeathBy(ServerPlayer player, DamageSource damageSource, Mob mob) {
        return DeathByMobUtil.getDeathCount(player, damageSource, mob) < 2;
    }
}

