/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.myosotis.util.data;

import com.github.cao.awa.myosotis.death.data.PlayerDeathDataAccessor;
import com.github.cao.awa.myosotis.server.world.session.ServerWorldSessionAccessor;
import com.github.cao.awa.sinuatum.util.io.IOUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import net.minecraft.class_1282;
import net.minecraft.class_3222;
import net.minecraft.class_3518;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerDeathDataUtil {
    private static final Logger LOGGER = LogManager.getLogger((String)"MyosotisPlayerDeathDataUtil");

    public static JsonObject getPlayerDeathData(class_3222 player) {
        try {
            return ((PlayerDeathDataAccessor)player).getDeathData();
        }
        catch (Exception e) {
            return new JsonObject();
        }
    }

    public static int getPlayerDeathCount(class_3222 player, class_1282 damageSource) {
        JsonElement deathCount = PlayerDeathDataUtil.getPlayerDeathData(player).get(damageSource.method_5525());
        if (deathCount == null) {
            return 0;
        }
        return deathCount.getAsInt();
    }

    public static boolean isFirstDeathBy(class_3222 player, class_1282 damageSource) {
        return PlayerDeathDataUtil.getPlayerDeathCount(player, damageSource) < 2;
    }

    public static JsonObject getPlayerDeathDataFromFile(class_3222 player) {
        try {
            return class_3518.method_15255((Reader)new FileReader(PlayerDeathDataUtil.getPlayerDeathDataFile(player)));
        }
        catch (Exception e) {
            return new JsonObject();
        }
    }

    public static void updatePayerDeathData(class_3222 player) {
        try {
            IOUtil.write((Writer)new FileWriter(PlayerDeathDataUtil.getPlayerDeathDataFile(player)), (String)PlayerDeathDataUtil.getPlayerDeathData(player).toString());
        }
        catch (Exception e) {
            LOGGER.warn("Failed to update player death data file for player {}", (Object)player.method_74861(), (Object)e);
        }
    }

    public static File getPlayerDeathDataFile(class_3222 player) {
        String fileName = String.valueOf(((ServerWorldSessionAccessor)player.method_51469()).getSession().method_54543().comp_732().toFile().getAbsoluteFile()) + "/myosotis/death_data/" + player.method_5845() + ".json";
        LOGGER.debug("Saving death data for player {} in {}", (Object)player.method_74861(), (Object)fileName);
        File file = new File(fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.isFile()) {
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to create player death data file for player {}", (Object)player.method_74861(), (Object)e);
            }
        }
        return file;
    }
}

