/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.myosotis.mixin.server.player;

import com.github.cao.awa.myosotis.death.data.PlayerDeathDataAccessor;
import com.github.cao.awa.myosotis.server.MyosotisServer;
import com.github.cao.awa.myosotis.util.data.PlayerDeathDataUtil;
import com.github.cao.awa.myosotis.util.mob.DeathByMobUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.authlib.GameProfile;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerEntityMixin
extends Player
implements PlayerDeathDataAccessor {
    private GameProfile profile;
    @Unique
    private final JsonObject myosotis$deathData = PlayerDeathDataUtil.getPlayerDeathDataFromFile((ServerPlayer)this.getLivingEntity());

    public ServerPlayerEntityMixin(Level world, GameProfile profile) {
        super(world, profile);
        this.profile = profile;
    }

    @Inject(method={"<init>(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/server/level/ServerLevel;Lcom/mojang/authlib/GameProfile;Lnet/minecraft/server/level/ClientInformation;)V"}, at={@At(value="RETURN")})
    public void onInit(MinecraftServer server, ServerLevel world, GameProfile profile, ClientInformation clientOptions, CallbackInfo ci) {
        this.profile = profile;
    }

    @Inject(method={"die(Lnet/minecraft/world/damagesource/DamageSource;)V"}, at={@At(value="HEAD")})
    public void onDeath(DamageSource damageSource, CallbackInfo ci) {
        MyosotisServer.deaths.put(this.profile.name(), damageSource);
        ServerPlayer player = (ServerPlayer)this.getLivingEntity();
        if (damageSource.is(DamageTypes.MOB_ATTACK)) {
            this.myosotis$mobAttackDeathCount(player, damageSource);
        } else if (damageSource.is(DamageTypes.ARROW)) {
            this.myosotis$mobAttackDeathCount(player, damageSource);
        } else {
            int deathCount = PlayerDeathDataUtil.getPlayerDeathCount(player, damageSource) + 1;
            this.myosotis$deathData.add(damageSource.getMsgId(), (JsonElement)new JsonPrimitive((Number)deathCount));
        }
        PlayerDeathDataUtil.updatePayerDeathData(player);
    }

    @Unique
    public void myosotis$mobAttackDeathCount(ServerPlayer player, DamageSource damageSource) {
        Entity entity = damageSource.getEntity();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            int deathCount = DeathByMobUtil.getDeathCount(player, damageSource, mob) + 1;
            this.myosotis$deathData.add(DeathByMobUtil.getDeathCountName(damageSource, mob), (JsonElement)new JsonPrimitive((Number)deathCount));
        }
    }

    @Override
    public JsonObject myosotis$getDeathData() {
        return this.myosotis$deathData;
    }
}

