/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.myosotis.mixin.server.player;

import com.github.cao.awa.myosotis.death.data.PlayerDeathDataAccessor;
import com.github.cao.awa.myosotis.server.MyosotisServer;
import com.github.cao.awa.myosotis.util.data.PlayerDeathDataUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.authlib.GameProfile;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerEntityMixin
extends Player
implements PlayerDeathDataAccessor {
    private GameProfile profile;
    @Unique
    private final JsonObject myosotis$deathData = PlayerDeathDataUtil.getPlayerDeathDataFromFile((ServerPlayer)this.getLivingEntity());

    public ServerPlayerEntityMixin(Level world, GameProfile profile) {
        super(world, profile);
        this.profile = profile;
    }

    @Inject(method={"<init>(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/server/level/ServerLevel;Lcom/mojang/authlib/GameProfile;Lnet/minecraft/server/level/ClientInformation;)V"}, at={@At(value="RETURN")})
    public void onInit(MinecraftServer server, ServerLevel world, GameProfile profile, ClientInformation clientOptions, CallbackInfo ci) {
        this.profile = profile;
    }

    @Inject(method={"die(Lnet/minecraft/world/damagesource/DamageSource;)V"}, at={@At(value="HEAD")})
    public void onDeath(DamageSource damageSource, CallbackInfo ci) {
        MyosotisServer.deaths.put(this.profile.name(), damageSource);
        int deathCount = 1;
        JsonElement deathCountElement = this.myosotis$deathData.get(damageSource.getMsgId());
        if (deathCountElement != null) {
            deathCount = deathCountElement.getAsInt() + 1;
        }
        this.myosotis$deathData.add(damageSource.getMsgId(), (JsonElement)new JsonPrimitive((Number)deathCount));
        PlayerDeathDataUtil.updatePayerDeathData((ServerPlayer)this.getLivingEntity());
    }

    @Override
    public JsonObject myosotis$getDeathData() {
        return this.myosotis$deathData;
    }
}

