/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.myosotis.mixin.server.world;

import com.github.cao.awa.myosotis.death.type.explosion.PlayerDeathByExplosion;
import com.github.cao.awa.myosotis.death.type.fall.PlayerDeathByFalling;
import com.github.cao.awa.myosotis.server.MyosotisServer;
import com.github.cao.awa.myosotis.server.world.session.ServerWorldSessionAccessor;
import com.github.cao.awa.myosotis.util.data.PlayerDeathDataUtil;
import java.util.List;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public class ServerWorldMixin
implements ServerWorldSessionAccessor {
    @Unique
    public LevelStorageSource.LevelStorageAccess myosotis$session;

    @Inject(method={"<init>(Lnet/minecraft/server/MinecraftServer;Ljava/util/concurrent/Executor;Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;Lnet/minecraft/world/level/storage/ServerLevelData;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/world/level/dimension/LevelStem;ZJLjava/util/List;ZLnet/minecraft/world/RandomSequences;)V"}, at={@At(value="RETURN")})
    public void onServerInit(MinecraftServer server, Executor workerExecutor, LevelStorageSource.LevelStorageAccess session, ServerLevelData properties, ResourceKey<Level> worldKey, LevelStem dimensionOptions, boolean debugWorld, long seed, List<CustomSpawner> spawners, boolean shouldTickTime, RandomSequences randomSequenceState, CallbackInfo ci) {
        this.myosotis$session = session;
    }

    @Inject(method={"addRespawnedPlayer(Lnet/minecraft/server/level/ServerPlayer;)V"}, at={@At(value="HEAD")})
    public void onPlayerRespawned(ServerPlayer player, CallbackInfo ci) {
        DamageSource damageSource = MyosotisServer.deaths.get(player.getPlainTextName());
        if (damageSource != null) {
            if (damageSource.is(DamageTypes.FALL) && PlayerDeathDataUtil.isFirstDeathBy(player, damageSource)) {
                PlayerDeathByFalling.tryRespawnWithFeather(player);
            }
            if (damageSource.is(DamageTypes.PLAYER_EXPLOSION) && damageSource.getEntity() instanceof Creeper && PlayerDeathDataUtil.isFirstDeathBy(player, damageSource)) {
                PlayerDeathByExplosion.tryRespawnWithFirework(player);
            }
            MyosotisServer.deaths.remove(player.getPlainTextName());
        }
    }

    @Override
    public LevelStorageSource.LevelStorageAccess myosotis$getSession() {
        return this.myosotis$session;
    }
}

