/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.myosotis.util.data;

import com.github.cao.awa.myosotis.death.data.PlayerDeathDataAccessor;
import com.github.cao.awa.myosotis.server.world.session.ServerWorldSessionAccessor;
import com.github.cao.awa.sinuatum.util.io.IOUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerDeathDataUtil {
    private static final Logger LOGGER = LogManager.getLogger((String)"MyosotisPlayerDeathDataUtil");

    public static JsonObject getPlayerDeathData(ServerPlayer player) {
        try {
            return ((PlayerDeathDataAccessor)player).getDeathData();
        }
        catch (Exception e) {
            return new JsonObject();
        }
    }

    public static int getPlayerDeathCount(ServerPlayer player, DamageSource damageSource) {
        JsonElement deathCount = PlayerDeathDataUtil.getPlayerDeathData(player).get(damageSource.getMsgId());
        if (deathCount == null) {
            return 0;
        }
        return deathCount.getAsInt();
    }

    public static boolean isFirstDeathBy(ServerPlayer player, DamageSource damageSource) {
        return PlayerDeathDataUtil.getPlayerDeathCount(player, damageSource) < 2;
    }

    public static JsonObject getPlayerDeathDataFromFile(ServerPlayer player) {
        try {
            return GsonHelper.parse((Reader)new FileReader(PlayerDeathDataUtil.getPlayerDeathDataFile(player)));
        }
        catch (Exception e) {
            return new JsonObject();
        }
    }

    public static void updatePayerDeathData(ServerPlayer player) {
        try {
            IOUtil.write((Writer)new FileWriter(PlayerDeathDataUtil.getPlayerDeathDataFile(player)), (String)PlayerDeathDataUtil.getPlayerDeathData(player).toString());
        }
        catch (Exception e) {
            LOGGER.warn("Failed to update player death data file for player {}", (Object)player.getPlainTextName(), (Object)e);
        }
    }

    public static File getPlayerDeathDataFile(ServerPlayer player) {
        String fileName = String.valueOf(((ServerWorldSessionAccessor)player.level()).getSession().getLevelDirectory().path().toFile().getAbsoluteFile()) + "/myosotis/death_data/" + player.getStringUUID() + ".json";
        LOGGER.debug("Saving death data for player {} in {}", (Object)player.getPlainTextName(), (Object)fileName);
        File file = new File(fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.isFile()) {
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to create player death data file for player {}", (Object)player.getPlainTextName(), (Object)e);
            }
        }
        return file;
    }
}

