/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.myosotis.mixin.server.player;

import com.github.cao.awa.myosotis.advancement.criterion.crieria.MyosotisCriteria;
import com.github.cao.awa.myosotis.death.data.PlayerDeathDataAccessor;
import com.github.cao.awa.myosotis.server.MyosotisServer;
import com.github.cao.awa.myosotis.util.data.PlayerDeathDataUtil;
import com.github.cao.awa.myosotis.util.mob.DeathByMobUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.authlib.GameProfile;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8111;
import net.minecraft.class_8791;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
extends class_1657
implements PlayerDeathDataAccessor {
    private GameProfile profile;
    @Unique
    private final JsonObject myosotis$deathData = PlayerDeathDataUtil.getPlayerDeathDataFromFile((class_3222)this.method_72382());

    public ServerPlayerEntityMixin(class_1937 world, GameProfile profile) {
        super(world, profile);
        this.profile = profile;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void onInit(MinecraftServer server, class_3218 world, GameProfile profile, class_8791 clientOptions, CallbackInfo ci) {
        this.profile = profile;
    }

    @Inject(method={"onDeath"}, at={@At(value="HEAD")})
    public void onDeath(class_1282 damageSource, CallbackInfo ci) {
        MyosotisServer.deaths.put(this.profile.name(), damageSource);
        class_3222 player = (class_3222)this.method_72382();
        if (damageSource.method_49708(class_8111.field_42360)) {
            this.myosotis$mobAttackDeathCount(player, damageSource);
        } else if (damageSource.method_49708(class_8111.field_42321)) {
            this.myosotis$mobAttackDeathCount(player, damageSource);
        } else {
            int deathCount = PlayerDeathDataUtil.getPlayerDeathCount(player, damageSource) + 1;
            this.myosotis$deathData.add(damageSource.method_5525(), (JsonElement)new JsonPrimitive((Number)deathCount));
        }
        PlayerDeathDataUtil.updatePayerDeathData(player);
        MyosotisCriteria.DEATH.trigger(player);
        if (damageSource.method_49708(class_8111.field_42360)) {
            MyosotisCriteria.KILL_BY_ENTITY.trigger(player, damageSource);
        }
        if (damageSource.method_49708(class_8111.field_42332)) {
            MyosotisCriteria.EXPLOSION_BY_ENTITY.trigger(player, damageSource);
        }
        if (damageSource.method_49708(class_8111.field_42345)) {
            MyosotisCriteria.DEATH_BY_FALLING.trigger(player, damageSource);
        }
    }

    @Unique
    public void myosotis$mobAttackDeathCount(class_3222 player, class_1282 damageSource) {
        class_1297 class_12972 = damageSource.method_5529();
        if (class_12972 instanceof class_1308) {
            class_1308 mob = (class_1308)class_12972;
            int deathCount = DeathByMobUtil.getDeathCount(player, damageSource, mob) + 1;
            this.myosotis$deathData.add(DeathByMobUtil.getDeathCountName(damageSource, mob), (JsonElement)new JsonPrimitive((Number)deathCount));
        }
    }

    @Override
    public JsonObject myosotis$getDeathData() {
        return this.myosotis$deathData;
    }
}

