/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.myosotis.mixin.server.world;

import com.github.cao.awa.myosotis.death.type.explosion.PlayerDeathByExplosion;
import com.github.cao.awa.myosotis.death.type.fall.PlayerDeathByFalling;
import com.github.cao.awa.myosotis.death.type.fly.PlayerDeathByFlyIntoWall;
import com.github.cao.awa.myosotis.death.type.mob.skeleton.PlayerDeathBySkeleton;
import com.github.cao.awa.myosotis.death.type.mob.spider.PlayerDeathBySpider;
import com.github.cao.awa.myosotis.death.type.mob.wolf.PlayerDeathByWolf;
import com.github.cao.awa.myosotis.death.type.mob.zombie.PlayerDeathByZombie;
import com.github.cao.awa.myosotis.server.MyosotisServer;
import com.github.cao.awa.myosotis.server.world.session.ServerWorldSessionAccessor;
import com.github.cao.awa.myosotis.util.data.PlayerDeathDataUtil;
import com.github.cao.awa.myosotis.util.mob.DeathByMobUtil;
import java.util.List;
import java.util.concurrent.Executor;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1493;
import net.minecraft.class_1548;
import net.minecraft.class_1613;
import net.minecraft.class_1628;
import net.minecraft.class_1642;
import net.minecraft.class_1937;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5268;
import net.minecraft.class_5304;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_8111;
import net.minecraft.class_8565;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3218.class})
public class ServerWorldMixin
implements ServerWorldSessionAccessor {
    @Unique
    public class_32.class_5143 myosotis$session;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void onServerInit(MinecraftServer server, Executor workerExecutor, class_32.class_5143 session, class_5268 properties, class_5321<class_1937> worldKey, class_5363 dimensionOptions, boolean debugWorld, long seed, List<class_5304> spawners, boolean shouldTickTime, class_8565 randomSequenceState, CallbackInfo ci) {
        this.myosotis$session = session;
    }

    @Inject(method={"onPlayerRespawned"}, at={@At(value="HEAD")})
    public void onPlayerRespawned(class_3222 player, CallbackInfo ci) {
        class_1282 damageSource = MyosotisServer.deaths.get(player.method_74861());
        if (damageSource != null) {
            class_1613 skeleton;
            class_1548 creeper;
            class_1297 class_12972;
            if (damageSource.method_49708(class_8111.field_42345) && PlayerDeathDataUtil.isFirstDeathBy(player, damageSource)) {
                PlayerDeathByFalling.tryRespawnWithFeather(player);
            }
            if (damageSource.method_49708(class_8111.field_42332) && (class_12972 = damageSource.method_5529()) instanceof class_1548 && PlayerDeathDataUtil.isFirstDeathBy(player, damageSource, (class_1308)(creeper = (class_1548)class_12972))) {
                PlayerDeathByExplosion.tryRespawnWithFirework(player);
            }
            if (damageSource.method_49708(class_8111.field_42360)) {
                class_1628 spider;
                class_1493 wolf;
                class_1642 zombie;
                class_12972 = damageSource.method_5529();
                if (class_12972 instanceof class_1642 && DeathByMobUtil.isFirstDeathBy(player, damageSource, (class_1308)(zombie = (class_1642)class_12972))) {
                    PlayerDeathByZombie.tryRespawnWithWoodenSword(player);
                }
                if ((class_12972 = damageSource.method_5529()) instanceof class_1493 && DeathByMobUtil.isFirstDeathBy(player, damageSource, (class_1308)(wolf = (class_1493)class_12972))) {
                    PlayerDeathByWolf.tryRespawnWithBones(player);
                }
                if ((class_12972 = damageSource.method_5529()) instanceof class_1628 && DeathByMobUtil.isFirstDeathBy(player, damageSource, (class_1308)(spider = (class_1628)class_12972))) {
                    PlayerDeathBySpider.tryRespawnWithString(player);
                }
            }
            if (damageSource.method_49708(class_8111.field_42321) && (class_12972 = damageSource.method_5529()) instanceof class_1613 && DeathByMobUtil.isFirstDeathBy(player, damageSource, (class_1308)(skeleton = (class_1613)class_12972))) {
                PlayerDeathBySkeleton.tryRespawnWithSecurity(player);
            }
            if (damageSource.method_49708(class_8111.field_42346) && PlayerDeathDataUtil.isFirstDeathBy(player, damageSource)) {
                PlayerDeathByFlyIntoWall.tryRespawnWithRocket(player);
            }
            MyosotisServer.deaths.remove(player.method_74861());
        }
    }

    @Override
    public class_32.class_5143 myosotis$getSession() {
        return this.myosotis$session;
    }
}

