/*
 * Decompiled with CFR 0.152.
 */
package com.playeranimations;

import com.playeranimations.animation.AnimationManager;
import com.playeranimations.commands.SitCommand;
import com.playeranimations.listeners.PlayerListener;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayerAnimationsPlugin
extends JavaPlugin {
    private static PlayerAnimationsPlugin instance;
    private AnimationManager animationManager;

    public void onEnable() {
        instance = this;
        this.animationManager = new AnimationManager((Plugin)this);
        if (this.getCommand("sit") != null) {
            this.getCommand("sit").setExecutor((CommandExecutor)new SitCommand(this.animationManager));
        } else {
            this.getLogger().severe("Failed to register /sit command - command not found in plugin.yml!");
        }
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this.animationManager), (Plugin)this);
        this.getLogger().info("Simple Sit Animation has been enabled!");
    }

    public void onDisable() {
        if (this.animationManager != null) {
            this.animationManager.cleanup();
        }
        this.getLogger().info("Simple Sit Animation has been disabled!");
    }

    public static PlayerAnimationsPlugin getInstance() {
        return instance;
    }

    public AnimationManager getAnimationManager() {
        return this.animationManager;
    }
}

