/*
 * Decompiled with CFR 0.152.
 */
package com.playeranimations.animation;

import com.playeranimations.animation.AnimationState;
import com.playeranimations.animation.AnimationType;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AnimationManager {
    private final Plugin plugin;
    private final Map<UUID, AnimationState> activeAnimations = new HashMap<UUID, AnimationState>();

    public AnimationManager(Plugin plugin) {
        this.plugin = plugin;
    }

    public boolean startSitting(Player player) {
        UUID playerId = player.getUniqueId();
        if (this.activeAnimations.containsKey(playerId)) {
            this.stopAnimation(player);
            return true;
        }
        Location loc = player.getLocation();
        ArmorStand armorStand = (ArmorStand)player.getWorld().spawnEntity(loc.clone(), EntityType.ARMOR_STAND);
        armorStand.setVisible(false);
        armorStand.setGravity(false);
        armorStand.setInvulnerable(true);
        armorStand.setSmall(false);
        armorStand.setBasePlate(false);
        armorStand.setArms(false);
        armorStand.setMarker(true);
        armorStand.setCustomNameVisible(false);
        armorStand.addPassenger((Entity)player);
        AnimationState state = new AnimationState(AnimationType.SIT, armorStand);
        this.activeAnimations.put(playerId, state);
        player.sendMessage("\u00a7aYou are now sitting! Use /sit again or sneak to stand up.");
        return true;
    }

    public boolean startLaying(Player player) {
        UUID playerId = player.getUniqueId();
        if (this.activeAnimations.containsKey(playerId)) {
            this.stopAnimation(player);
            return true;
        }
        Location loc = player.getLocation();
        ArmorStand armorStand = (ArmorStand)player.getWorld().spawnEntity(loc.clone().subtract(0.0, 1.7, 0.0), EntityType.ARMOR_STAND);
        armorStand.setVisible(false);
        armorStand.setGravity(false);
        armorStand.setInvulnerable(true);
        armorStand.setSmall(false);
        armorStand.setBasePlate(false);
        armorStand.setArms(false);
        armorStand.setMarker(true);
        armorStand.setCustomNameVisible(false);
        armorStand.addPassenger((Entity)player);
        AnimationState state = new AnimationState(AnimationType.LAY, armorStand);
        this.activeAnimations.put(playerId, state);
        player.sendMessage("\u00a7aYou are now laying down! Use /lay again or sneak to stand up.");
        return true;
    }

    public boolean startWaving(final Player player) {
        player.sendMessage("\u00a7aYou wave!");
        new BukkitRunnable(this){
            int count = 0;

            public void run() {
                if (!player.isOnline() || this.count >= 10) {
                    this.cancel();
                    return;
                }
                player.swingMainHand();
                ++this.count;
            }
        }.runTaskTimer(this.plugin, 0L, 10L);
        return true;
    }

    public void stopAnimation(Player player) {
        UUID playerId = player.getUniqueId();
        AnimationState state = this.activeAnimations.remove(playerId);
        if (state == null) {
            return;
        }
        if (state.getArmorStand() != null && state.getArmorStand().isValid()) {
            state.getArmorStand().remove();
        }
        player.setSwimming(false);
        player.sendMessage("\u00a77Animation stopped.");
    }

    public boolean isInAnimation(Player player) {
        return this.activeAnimations.containsKey(player.getUniqueId());
    }

    public void cleanup() {
        for (AnimationState state : this.activeAnimations.values()) {
            if (state.getArmorStand() == null || !state.getArmorStand().isValid()) continue;
            state.getArmorStand().remove();
        }
        this.activeAnimations.clear();
    }

    public void handleDismount(Player player) {
        UUID playerId = player.getUniqueId();
        AnimationState state = this.activeAnimations.get(playerId);
        if (state != null && state.getType() == AnimationType.SIT) {
            Bukkit.getScheduler().runTaskLater(this.plugin, () -> this.stopAnimation(player), 1L);
        }
    }
}

