/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane;

import de.maxhenkel.plane.PlaneMod;
import de.maxhenkel.plane.entity.render.BushPlaneModel;
import de.maxhenkel.plane.entity.render.CargoPlaneModel;
import de.maxhenkel.plane.entity.render.PlaneModel;
import de.maxhenkel.plane.entity.render.TransporterPlaneModel;
import de.maxhenkel.plane.events.KeyEvents;
import de.maxhenkel.plane.events.RenderEvents;
import de.maxhenkel.plane.gui.ContainerPlane;
import de.maxhenkel.plane.gui.PlaneScreen;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="plane", dist={Dist.CLIENT})
@EventBusSubscriber(modid="plane", value={Dist.CLIENT})
public class PlaneClientMod {
    public static KeyMapping.Category KEY_CATEGORY_PLANE;
    public static KeyMapping PLANE_KEY;
    public static KeyMapping FORWARD_KEY;
    public static KeyMapping BACK_KEY;
    public static KeyMapping LEFT_KEY;
    public static KeyMapping RIGHT_KEY;
    public static KeyMapping UP_KEY;
    public static KeyMapping DOWN_KEY;
    public static KeyMapping START_KEY;
    public static KeyMapping BRAKE_KEY;

    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        NeoForge.EVENT_BUS.register((Object)new KeyEvents());
        NeoForge.EVENT_BUS.register((Object)new RenderEvents());
        EntityRenderers.register((EntityType)((EntityType)PlaneMod.PLANE_ENTITY_TYPE.get()), manager -> new PlaneModel(manager));
        EntityRenderers.register((EntityType)((EntityType)PlaneMod.CARGO_PLANE_ENTITY_TYPE.get()), manager -> new CargoPlaneModel(manager));
        EntityRenderers.register((EntityType)((EntityType)PlaneMod.TRANSPORTER_PLANE_ENTITY_TYPE.get()), manager -> new TransporterPlaneModel(manager));
        EntityRenderers.register((EntityType)((EntityType)PlaneMod.BUSH_PLANE_ENTITY_TYPE.get()), manager -> new BushPlaneModel(manager));
    }

    @SubscribeEvent
    static void onRegisterKeyBinds(RegisterKeyMappingsEvent event) {
        KEY_CATEGORY_PLANE = new KeyMapping.Category(Identifier.fromNamespaceAndPath((String)"plane", (String)"plane"));
        event.registerCategory(KEY_CATEGORY_PLANE);
        PLANE_KEY = new KeyMapping("key.plane", 80, KEY_CATEGORY_PLANE);
        FORWARD_KEY = new KeyMapping("key.plane_add_thrust", 73, KEY_CATEGORY_PLANE);
        BACK_KEY = new KeyMapping("key.plane_remove_thrust", 75, KEY_CATEGORY_PLANE);
        LEFT_KEY = new KeyMapping("key.plane_left", 65, KEY_CATEGORY_PLANE);
        RIGHT_KEY = new KeyMapping("key.plane_right", 68, KEY_CATEGORY_PLANE);
        UP_KEY = new KeyMapping("key.plane_up", 83, KEY_CATEGORY_PLANE);
        DOWN_KEY = new KeyMapping("key.plane_down", 87, KEY_CATEGORY_PLANE);
        START_KEY = new KeyMapping("key.plane_start", 82, KEY_CATEGORY_PLANE);
        BRAKE_KEY = new KeyMapping("key.plane_brake", 66, KEY_CATEGORY_PLANE);
        event.register(PLANE_KEY);
        event.register(FORWARD_KEY);
        event.register(BACK_KEY);
        event.register(LEFT_KEY);
        event.register(RIGHT_KEY);
        event.register(UP_KEY);
        event.register(DOWN_KEY);
        event.register(START_KEY);
        event.register(BRAKE_KEY);
    }

    @SubscribeEvent
    static void onRegisterScreens(RegisterMenuScreensEvent containers) {
        MenuScreens.ScreenConstructor factory = (container, playerInventory, name) -> new PlaneScreen((ContainerPlane)container, playerInventory, name);
        containers.register((MenuType)PlaneMod.PLANE_CONTAINER_TYPE.get(), factory);
    }
}

