/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane;

import de.maxhenkel.plane.corelib.config.ConfigBase;
import de.maxhenkel.plane.corelib.tag.Tag;
import de.maxhenkel.plane.corelib.tag.TagUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ServerConfig
extends ConfigBase {
    public final ModConfigSpec.DoubleValue maxPlaneDamage;
    public final ModConfigSpec.BooleanValue planeToPlaneCollision;
    public final ModConfigSpec.IntValue bushPlaneFuelCapacity;
    public final ModConfigSpec.IntValue planeFuelCapacity;
    public final ModConfigSpec.IntValue cargoPlaneFuelCapacity;
    public final ModConfigSpec.IntValue transporterPlaneFuelCapacity;
    public final ModConfigSpec.DoubleValue bushPlaneBaseFuelUsage;
    public final ModConfigSpec.DoubleValue planeBaseFuelUsage;
    public final ModConfigSpec.DoubleValue cargoPlaneBaseFuelUsage;
    public final ModConfigSpec.DoubleValue transporterPlaneBaseFuelUsage;
    private final ModConfigSpec.ConfigValue<List<? extends String>> validFuelsSpec;
    public List<Tag<Fluid>> validFuels = new ArrayList<Tag<Fluid>>();

    public ServerConfig(ModConfigSpec.Builder builder) {
        super(builder);
        this.maxPlaneDamage = builder.worldRestart().defineInRange("plane.max_damage", 200.0, 100.0, Double.MAX_VALUE);
        this.planeToPlaneCollision = builder.worldRestart().define("plane.plane_to_plane_collision", true);
        this.bushPlaneFuelCapacity = builder.worldRestart().defineInRange("plane.bush_plane.fuel_capacity", 8000, 1000, Integer.MAX_VALUE);
        this.planeFuelCapacity = builder.worldRestart().defineInRange("plane.plane.fuel_capacity", 10000, 1000, Integer.MAX_VALUE);
        this.cargoPlaneFuelCapacity = builder.worldRestart().defineInRange("plane.cargo.fuel_capacity", 16000, 1000, Integer.MAX_VALUE);
        this.transporterPlaneFuelCapacity = builder.worldRestart().defineInRange("plane.transporter.fuel_capacity", 16000, 1000, Integer.MAX_VALUE);
        this.bushPlaneBaseFuelUsage = builder.worldRestart().defineInRange("plane.bush_plane.base_fuel_usage", 0.75, 0.01, 16.0);
        this.planeBaseFuelUsage = builder.worldRestart().defineInRange("plane.plane.base_fuel_usage", 0.8, 0.01, 16.0);
        this.cargoPlaneBaseFuelUsage = builder.worldRestart().defineInRange("plane.cargo.base_fuel_usage", 1.05, 0.01, 16.0);
        this.transporterPlaneBaseFuelUsage = builder.worldRestart().defineInRange("plane.transporter.base_fuel_usage", (double)0.95f, 0.01, 16.0);
        this.validFuelsSpec = builder.worldRestart().defineList("plane.valid_fuels", () -> List.of("#car:gas_station"), () -> "", Objects::nonNull);
    }

    @Override
    public void onReload(ModConfigEvent.Reloading event) {
        super.onReload(event);
        this.onConfigChanged();
    }

    @Override
    public void onLoad(ModConfigEvent.Loading evt) {
        super.onLoad(evt);
        this.onConfigChanged();
    }

    private void onConfigChanged() {
        this.validFuels = ((List)this.validFuelsSpec.get()).stream().map(TagUtils::getFluid).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

