/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import de.maxhenkel.plane.PlaneMod;
import de.maxhenkel.plane.corelib.item.ItemUtils;
import de.maxhenkel.plane.entity.EntityPlaneBase;
import de.maxhenkel.plane.gui.ContainerPlane;
import de.maxhenkel.plane.net.MessagePlaneGui;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class EntityCargoPlane
extends EntityPlaneBase {
    private static final Vec3 BODY_CENTER = new Vec3(0.0, 0.0, -1.09375);
    private final Container cargoInventory = new SimpleContainer(54);

    public EntityCargoPlane(Level world) {
        this((EntityType<?>)((EntityType)PlaneMod.CARGO_PLANE_ENTITY_TYPE.get()), world);
    }

    public EntityCargoPlane(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Override
    public float getPlayerScaleFactor() {
        return 0.8f;
    }

    @Override
    public void destroyPlane(ServerLevel level, DamageSource source, Player player) {
        Containers.dropContents((Level)this.level(), (BlockPos)this.blockPosition(), (Container)this.cargoInventory);
        this.cargoInventory.clearContent();
        super.destroyPlane(level, source, player);
    }

    @Override
    public void openGUI(Player player, boolean outside) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (outside) {
                serverPlayer.openMenu(new MenuProvider(){

                    public Component getDisplayName() {
                        return Component.translatable((String)"gui.plane.cargo_inventory");
                    }

                    @Nullable
                    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
                        return ChestMenu.sixRows((int)i, (Inventory)playerInventory, (Container)EntityCargoPlane.this.cargoInventory);
                    }
                });
            } else {
                serverPlayer.openMenu(new MenuProvider(){

                    public Component getDisplayName() {
                        return EntityCargoPlane.this.getName();
                    }

                    @Nullable
                    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
                        return new ContainerPlane(i, EntityCargoPlane.this, playerInventory);
                    }
                }, packetBuffer -> packetBuffer.writeUUID(this.getUUID()));
            }
        } else {
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new MessagePlaneGui(player, outside), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        ItemUtils.readInventory(valueInput, "CargoInventory", this.cargoInventory);
    }

    @Override
    public Vec3 getBodyRotationCenter() {
        return BODY_CENTER;
    }

    @Override
    public void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        ItemUtils.saveInventory(valueOutput, "CargoInventory", this.cargoInventory);
    }

    @Override
    public int getFuelCapacity() {
        return (Integer)PlaneMod.SERVER_CONFIG.cargoPlaneFuelCapacity.get();
    }

    @Override
    protected float getBaseFuelUsage() {
        return ((Double)PlaneMod.SERVER_CONFIG.cargoPlaneBaseFuelUsage.get()).floatValue();
    }

    @Override
    public double getFallSpeed() {
        return 0.11;
    }

    @Override
    public Vec3[] getPlayerOffsets() {
        return new Vec3[]{new Vec3(0.5, 0.0, 0.8), new Vec3(-0.5, 0.0, 0.8)};
    }

    @Override
    public ResourceKey<LootTable> getPlaneLootTable() {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (Identifier)Identifier.fromNamespaceAndPath((String)"plane", (String)("entities/cargo_plane_" + this.getPlaneType().getTypeName())));
    }
}

