/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import de.maxhenkel.plane.PlaneMod;
import de.maxhenkel.plane.entity.EntityPlaneBase;
import de.maxhenkel.plane.gui.ContainerPlane;
import de.maxhenkel.plane.net.MessagePlaneGui;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class EntityPlane
extends EntityPlaneBase {
    private static final Vec3 BODY_CENTER = new Vec3(0.0, 0.0, -1.09375);

    public EntityPlane(Level world) {
        this((EntityType<?>)((EntityType)PlaneMod.PLANE_ENTITY_TYPE.get()), world);
    }

    public EntityPlane(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Override
    public float getPlayerScaleFactor() {
        return 0.8f;
    }

    @Override
    public void openGUI(Player player, boolean outside) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return EntityPlane.this.getName();
                }

                @Nullable
                public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
                    return new ContainerPlane(i, EntityPlane.this, playerInventory);
                }
            }, packetBuffer -> packetBuffer.writeUUID(this.getUUID()));
        } else {
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new MessagePlaneGui(player, outside), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public int getFuelCapacity() {
        return (Integer)PlaneMod.SERVER_CONFIG.planeFuelCapacity.get();
    }

    @Override
    protected float getBaseFuelUsage() {
        return ((Double)PlaneMod.SERVER_CONFIG.planeBaseFuelUsage.get()).floatValue();
    }

    @Override
    public double getFallSpeed() {
        return 0.1;
    }

    @Override
    public Vec3[] getPlayerOffsets() {
        return new Vec3[]{new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 0.5), new Vec3(0.0, 0.0, 0.0)};
    }

    @Override
    public ResourceKey<LootTable> getPlaneLootTable() {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (Identifier)Identifier.fromNamespaceAndPath((String)"plane", (String)("entities/plane_" + this.getPlaneType().getTypeName())));
    }

    @Override
    public Vec3 getBodyRotationCenter() {
        return BODY_CENTER;
    }
}

