/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import de.maxhenkel.plane.DamageSourcePlane;
import de.maxhenkel.plane.PlaneMod;
import de.maxhenkel.plane.entity.EntityFlyableBase;
import de.maxhenkel.plane.entity.EntityPlaneControlBase;
import de.maxhenkel.plane.entity.EntityPlaneInventoryBase;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import de.maxhenkel.plane.item.ModItems;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public abstract class EntityPlaneDamageBase
extends EntityFlyableBase {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(EntityPlaneDamageBase.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private final BlockingQueue<Runnable> tasks = new LinkedBlockingQueue<Runnable>();

    public EntityPlaneDamageBase(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public void tick() {
        EntityPlaneControlBase plane;
        EntityPlaneDamageBase entityPlaneDamageBase;
        Runnable task;
        super.tick();
        while ((task = (Runnable)this.tasks.poll()) != null) {
            task.run();
        }
        if (this.isInLava()) {
            this.setPlaneDamage(this.getPlaneDamage() + 1.0f);
        }
        if (this.isEyeInFluidType(Fluids.WATER.getFluidType()) && (entityPlaneDamageBase = this) instanceof EntityPlaneControlBase && (plane = (EntityPlaneControlBase)entityPlaneDamageBase).isStarted()) {
            this.setPlaneDamage(this.getPlaneDamage() + 50.0f);
            plane.setStarted(false);
        }
        this.handleParticles();
    }

    protected void handleParticles() {
        if (!this.level().isClientSide()) {
            return;
        }
        if (!((EntityPlaneSoundBase)this).isStarted()) {
            return;
        }
        float damage = this.getPlaneDamage();
        float chance = Math.max(damage - 25.0f, 0.0f) / 100.0f;
        if (this.random.nextFloat() < chance) {
            Vec3 lookVec = this.getLookAngle().normalize().scale(1.5);
            this.spawnParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, lookVec.x, lookVec.y, lookVec.z);
        }
    }

    private void spawnParticle(ParticleOptions particleTypes, double offX, double offY, double offZ, double rand) {
        this.level().addParticle(particleTypes, this.getX() + offX + (this.random.nextDouble() * rand - rand / 2.0), this.getY() + (double)this.getBbHeight() / 2.0 + offY + (this.random.nextDouble() * rand - rand / 2.0), this.getZ() + offZ + (this.random.nextDouble() * rand - rand / 2.0), 0.0, 0.0, 0.0);
    }

    private void spawnParticle(ParticleOptions particleTypes, double offX, double offY, double offZ) {
        this.spawnParticle(particleTypes, offX, offY, offZ, 1.0);
    }

    @Override
    public void damagePlane(float damage, boolean horizontal) {
        super.damagePlane(damage, horizontal);
        this.setPlaneDamage(this.getPlaneDamage() + damage);
        this.damagePassengers(damage);
    }

    protected void damagePassengers(float planeDamage) {
        if (planeDamage < 20.0f) {
            return;
        }
        planeDamage = Math.min(planeDamage, 200.0f);
        float entityDamage = planeDamage / 10.0f;
        for (Entity entity : this.getPassengers()) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            this.damageEntity((Entity)livingEntity, entityDamage, DamageSourcePlane.DAMAGE_PLANE_CRASH);
        }
    }

    public boolean hurtServer(ServerLevel level, DamageSource source, float amount) {
        if (this.isInvulnerable()) {
            return false;
        }
        if (this.level().isClientSide() || !this.isAlive()) {
            return false;
        }
        if (!(source.getDirectEntity() instanceof Player)) {
            return false;
        }
        Player player = (Player)source.getDirectEntity();
        if (player == null) {
            return false;
        }
        if (this.hasPassenger((Entity)player)) {
            return false;
        }
        if (player.getAbilities().instabuild && player.isShiftKeyDown()) {
            this.destroyPlane(level, source, player);
            return true;
        }
        ItemStack heldItem = player.getMainHandItem();
        if (heldItem.getItem().equals(ModItems.WRENCH.get()) && heldItem.getMaxDamage() - heldItem.getDamageValue() >= 512) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                heldItem.hurtAndBreak(512, serverPlayer.level(), serverPlayer, item -> {});
            }
            this.destroyPlane(level, source, player);
        }
        return false;
    }

    public void destroyPlane(ServerLevel level, DamageSource source, Player player) {
        Container inventory = ((EntityPlaneInventoryBase)this).getInventory();
        Containers.dropContents((Level)this.level(), (BlockPos)this.blockPosition(), (Container)inventory);
        inventory.clearContent();
        ResourceKey<LootTable> lootTable = this.getPlaneLootTable();
        if (lootTable != null) {
            LootTable table = this.level().getServer().reloadableRegistries().getLootTable(lootTable);
            LootParams.Builder context = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)source).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)player).withParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)player);
            table.getRandomItems(context.create(LootContextParamSets.ENTITY)).forEach(stack -> this.spawnAtLocation(level, (ItemStack)stack));
        }
        this.kill(level);
    }

    @Nullable
    public abstract ResourceKey<LootTable> getPlaneLootTable();

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public float getPlaneDamage() {
        return ((Float)this.entityData.get(DAMAGE)).floatValue();
    }

    public void setPlaneDamage(float damage) {
        this.entityData.set(DAMAGE, (Object)Float.valueOf(Math.min(damage, ((Double)PlaneMod.SERVER_CONFIG.maxPlaneDamage.get()).floatValue())));
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        this.damageEntityCollided(entity);
        return super.canCollideWith(entity);
    }

    protected void damageEntityCollided(Entity entity) {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (this.getPassengers().contains(livingEntity)) {
            return;
        }
        if (!livingEntity.getBoundingBox().intersects(this.getBoundingBox())) {
            return;
        }
        if (livingEntity instanceof ServerPlayer && !livingEntity.onGround()) {
            return;
        }
        double speed = this.getDeltaMovement().length();
        if (speed <= (double)0.35f) {
            return;
        }
        float damage = Math.min((float)(speed * 10.0), 15.0f);
        this.damageEntity(entity, damage, DamageSourcePlane.DAMAGE_HIT_PLANE);
    }

    protected void damageEntity(Entity entity, float damage, ResourceKey<DamageType> damageType) {
        this.tasks.add(() -> {
            Optional holder = this.level().registryAccess().get(damageType);
            holder.ifPresent(damageTypeReference -> entity.hurt(new DamageSource((Holder)damageTypeReference, (Entity)this), damage));
        });
    }

    public boolean displayFireAnimation() {
        return false;
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.setPlaneDamage(valueInput.getFloatOr("Damage", 0.0f));
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putFloat("Damage", this.getPlaneDamage());
    }
}

