/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import de.maxhenkel.plane.PlaneMod;
import de.maxhenkel.plane.entity.EntityPlaneControlBase;
import java.util.AbstractMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public abstract class EntityPlaneFuelBase
extends EntityPlaneControlBase
implements ResourceHandler<FluidResource> {
    private static final EntityDataAccessor<Integer> FUEL = SynchedEntityData.defineId(EntityPlaneFuelBase.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<String> FUEL_TYPE = SynchedEntityData.defineId(EntityPlaneFuelBase.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private float fuelAccumulator;
    private final SnapshotJournal<Map.Entry<Fluid, Integer>> fluidJournal = new SnapshotJournal<Map.Entry<Fluid, Integer>>(){

        protected Map.Entry<Fluid, Integer> createSnapshot() {
            return new AbstractMap.SimpleEntry<Fluid, Integer>(EntityPlaneFuelBase.this.getFuelType(), EntityPlaneFuelBase.this.getFuel());
        }

        protected void revertToSnapshot(Map.Entry<Fluid, Integer> snapshot) {
            Fluid fluid = snapshot.getKey();
            if (fluid == null) {
                EntityPlaneFuelBase.this.setFuelType("");
            } else {
                EntityPlaneFuelBase.this.setFuelType(fluid);
            }
            EntityPlaneFuelBase.this.setFuel(snapshot.getValue());
        }
    };

    public EntityPlaneFuelBase(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    public abstract int getFuelCapacity();

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            this.fuelTick();
        }
    }

    protected void fuelTick() {
        if (!this.isStarted()) {
            return;
        }
        this.setFuel(Math.max(this.getFuel() - this.calculateFuelUsage(), 0));
    }

    protected int calculateFuelUsage() {
        float maxUsage = this.getBaseFuelUsage() * this.getFuelMultiplier();
        float idleUsage = Math.max(Math.min(this.getIdleUsageMultiplier(), 1.0f), 0.0f);
        maxUsage = maxUsage * idleUsage + maxUsage * this.getEngineSpeed() * (1.0f - idleUsage);
        this.fuelAccumulator += maxUsage;
        int fuelInt = (int)this.fuelAccumulator;
        this.fuelAccumulator -= (float)fuelInt;
        return fuelInt;
    }

    protected abstract float getBaseFuelUsage();

    protected float getFuelMultiplier() {
        return 1.0f;
    }

    protected float getIdleUsageMultiplier() {
        return 0.1f;
    }

    @Override
    public boolean canEngineBeStarted() {
        if (this.getFuel() <= 0) {
            return false;
        }
        return super.canEngineBeStarted();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FUEL, (Object)0);
        builder.define(FUEL_TYPE, (Object)"");
    }

    @Override
    public void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.setFuel(valueInput.getIntOr("Fuel", 0));
        this.setFuelType(valueInput.getStringOr("FuelType", ""));
    }

    @Override
    public void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putInt("Fuel", this.getFuel());
        Fluid fuel = this.getFuelType();
        valueOutput.putString("FuelType", fuel == null ? "" : BuiltInRegistries.FLUID.getKey((Object)fuel).toString());
    }

    @Nullable
    public Fluid getFuelType() {
        String type = (String)this.entityData.get(FUEL_TYPE);
        if (type.isEmpty()) {
            return null;
        }
        Identifier resourceLocation = Identifier.tryParse((String)type);
        if (resourceLocation == null) {
            return null;
        }
        return BuiltInRegistries.FLUID.get(resourceLocation).map(Holder.Reference::value).orElse(null);
    }

    public void setFuelType(Fluid fluid) {
        this.setFuelType(BuiltInRegistries.FLUID.getKey((Object)fluid).toString());
    }

    public void setFuelType(String fluid) {
        this.entityData.set(FUEL_TYPE, (Object)fluid);
    }

    public int getFuel() {
        return (Integer)this.entityData.get(FUEL);
    }

    public void setFuel(int fuel) {
        this.entityData.set(FUEL, (Object)fuel);
    }

    public boolean isValidFuel(Fluid fluid) {
        return PlaneMod.SERVER_CONFIG.validFuels.stream().anyMatch(fluidTag -> fluidTag.contains(fluid));
    }

    public int size() {
        return 1;
    }

    public FluidResource getResource(int index) {
        Fluid fluid = this.getFuelType();
        return fluid == null ? FluidResource.EMPTY : FluidResource.of((Fluid)fluid);
    }

    public long getAmountAsLong(int index) {
        return this.getFuel();
    }

    public long getCapacityAsLong(int index, FluidResource resource) {
        return this.getFuelCapacity();
    }

    public boolean isValid(int index, FluidResource resource) {
        return this.isValidFuel(resource.getFluid());
    }

    public int insert(int index, FluidResource resource, int amount, TransactionContext transaction) {
        if (!this.isValidFuel(resource.getFluid())) {
            return 0;
        }
        Fluid fluid = this.getFuelType();
        if (fluid != null && this.getFuel() > 0 && !resource.getFluid().equals(fluid)) {
            return 0;
        }
        int result = Math.min(amount, this.getFuelCapacity() - this.getFuel());
        this.fluidJournal.updateSnapshots(transaction);
        int i = this.getFuel() + result;
        if (i > this.getFuelCapacity()) {
            i = this.getFuelCapacity();
        }
        this.setFuel(i);
        this.setFuelType(resource.getFluid());
        return result;
    }

    public int extract(int index, FluidResource resource, int amount, TransactionContext transaction) {
        return 0;
    }
}

