/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import de.maxhenkel.plane.corelib.item.ItemUtils;
import de.maxhenkel.plane.entity.EntityPlaneFuelBase;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class EntityPlaneInventoryBase
extends EntityPlaneFuelBase {
    private Container inventory = new SimpleContainer(27);

    public EntityPlaneInventoryBase(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        if (player.isShiftKeyDown()) {
            if (!this.level().isClientSide()) {
                this.openGUI(player, true);
            }
            return InteractionResult.SUCCESS;
        }
        return super.interact(player, hand);
    }

    public abstract void openGUI(Player var1, boolean var2);

    public Container getInventory() {
        return this.inventory;
    }

    @Override
    public void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        ItemUtils.readInventory(valueInput, "Inventory", this.inventory);
    }

    @Override
    public void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        ItemUtils.saveInventory(valueOutput, "Inventory", this.inventory);
    }
}

