/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import de.maxhenkel.plane.entity.EntityPlaneWheelBase;
import de.maxhenkel.plane.entity.PlaneClientSoundManager;
import de.maxhenkel.plane.sound.ModSounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public abstract class EntityPlaneSoundBase
extends EntityPlaneWheelBase {
    private PlaneClientSoundManager soundManager;

    public EntityPlaneSoundBase(EntityType type, Level level) {
        super(type, level);
        if (level.isClientSide()) {
            this.soundManager = new PlaneClientSoundManager(this);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.soundManager.updateSounds();
        }
    }

    @Override
    public void setStarted(boolean started) {
        super.setStarted(started);
        if (this.level().isClientSide()) {
            this.soundManager.setStarted(started, true);
        }
    }

    public void setStarted(boolean started, boolean playSound) {
        if (this.level().isClientSide()) {
            this.soundManager.setStarted(started, playSound);
        }
    }

    @Override
    public void damagePlane(float damage, boolean horizontal) {
        super.damagePlane(damage, horizontal);
        ModSounds.playSound((SoundEvent)ModSounds.CRASH.get(), this.level(), this.blockPosition(), null, SoundSource.NEUTRAL, 1.0f);
    }
}

