/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import com.google.common.collect.ImmutableList;
import de.maxhenkel.plane.PlaneMod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class EntityVehicleBase
extends Entity {
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    protected float deltaRotation;

    public EntityVehicleBase(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.blocksBuilding = true;
    }

    public float maxUpStep() {
        return 0.6f;
    }

    public void tick() {
        super.tick();
        this.tickLerp();
    }

    public Player getDriver() {
        List passengers = this.getPassengers();
        if (passengers.size() <= 0) {
            return null;
        }
        if (passengers.get(0) instanceof Player) {
            return (Player)passengers.get(0);
        }
        return null;
    }

    protected void addPassenger(Entity passenger) {
        ArrayList<Entity> p = new ArrayList<Entity>((Collection<Entity>)this.passengers);
        p.add(passenger);
        this.passengers = ImmutableList.copyOf(p);
        if (this.isLocalClientAuthoritative() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.snapTo(this.lerpX, this.lerpY, this.lerpZ, (float)this.lerpYRot, (float)this.lerpXRot);
        }
    }

    public abstract int getPassengerSize();

    protected boolean canAddPassenger(Entity passenger) {
        return this.getPassengers().size() < this.getPassengerSize();
    }

    private void tickLerp() {
        if (this.isLocalClientAuthoritative()) {
            this.lerpSteps = 0;
            this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
        }
        if (this.lerpSteps > 0) {
            double x = this.getX() + (this.lerpX - this.getX()) / (double)this.lerpSteps;
            double y = this.getY() + (this.lerpY - this.getY()) / (double)this.lerpSteps;
            double z = this.getZ() + (this.lerpZ - this.getZ()) / (double)this.lerpSteps;
            double ry = Mth.wrapDegrees((double)(this.lerpYRot - (double)this.getYRot()));
            this.setYRot((float)((double)this.getYRot() + ry / (double)this.lerpSteps));
            this.setXRot((float)((double)this.getXRot() + (this.lerpXRot - (double)this.getXRot()) / (double)this.lerpSteps));
            --this.lerpSteps;
            this.setPos(x, y, z);
            this.setRot(this.getYRot(), this.getXRot());
        }
    }

    public void moveOrInterpolateTo(Vec3 pos, float yaw, float pitch) {
        this.lerpX = pos.x;
        this.lerpY = pos.y;
        this.lerpZ = pos.z;
        this.lerpYRot = yaw;
        this.lerpXRot = pitch;
        this.lerpSteps = 10;
    }

    protected void applyOriantationsToEntity(Entity entityToUpdate) {
        entityToUpdate.setYBodyRot(this.getYRot());
        float f = Mth.wrapDegrees((float)(entityToUpdate.getYRot() - this.getYRot()));
        float f1 = Mth.clamp((float)f, (float)-130.0f, (float)130.0f);
        entityToUpdate.yRotO += f1 - f;
        entityToUpdate.setYRot(entityToUpdate.getYRot() + f1 - f);
        entityToUpdate.setYHeadRot(entityToUpdate.getYRot());
    }

    public void onPassengerTurned(Entity entityToUpdate) {
        this.applyOriantationsToEntity(entityToUpdate);
    }

    public abstract Vec3[] getPlayerOffsets();

    public void positionRider(Entity passenger, Entity.MoveFunction moveFunction) {
        if (!this.hasPassenger(passenger)) {
            return;
        }
        List passengers = this.getPassengers();
        if (passengers.size() > 0) {
            int i = passengers.indexOf(passenger);
            Vec3 offset = this.getPlayerOffsets()[i];
            offset = offset.yRot((float)(-Math.toRadians(this.getYRot())));
            passenger.setPos(this.getX() + offset.x, this.getY() + offset.y, this.getZ() + offset.z);
            passenger.setYRot(passenger.getYRot() + this.deltaRotation);
            passenger.setYHeadRot(passenger.getYHeadRot() + this.deltaRotation);
        }
        this.applyOriantationsToEntity(passenger);
    }

    public LivingEntity getControllingPassenger() {
        return this.getDriver();
    }

    public boolean canCollideWith(Entity entity) {
        if (((Boolean)PlaneMod.SERVER_CONFIG.planeToPlaneCollision.get()).booleanValue()) {
            return entity instanceof EntityVehicleBase;
        }
        return false;
    }

    public boolean canBeCollidedWith(@Nullable Entity p_423659_) {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean isPickable() {
        return true;
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (!player.isShiftKeyDown()) {
            if (player.getVehicle() != this && !this.level().isClientSide()) {
                player.startRiding((Entity)this);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }
}

