/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import de.maxhenkel.plane.sound.ModClientSounds;
import de.maxhenkel.plane.sound.ModSounds;
import de.maxhenkel.plane.sound.SoundLoopHigh;
import de.maxhenkel.plane.sound.SoundLoopIdle;
import de.maxhenkel.plane.sound.SoundLoopStart;
import de.maxhenkel.plane.sound.SoundLoopStarting;
import de.maxhenkel.plane.sound.SoundLoopStop;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;

public class PlaneClientSoundManager {
    private final EntityPlaneSoundBase plane;
    private SoundLoopStart startLoop;
    private SoundLoopIdle idleLoop;
    private SoundLoopHigh highLoop;
    private SoundLoopStarting startingLoop;
    private SoundLoopStop stopLoop;
    private int ticksSinceStarted = 0;

    public PlaneClientSoundManager(EntityPlaneSoundBase plane) {
        this.plane = plane;
    }

    public void updateSounds() {
        if (this.plane.isStarted()) {
            if (this.ticksSinceStarted >= 20) {
                if (this.plane.getEngineSpeed() <= 0.0f) {
                    this.checkIdleLoop();
                } else {
                    this.checkHighLoop();
                }
            } else {
                ++this.ticksSinceStarted;
            }
        } else {
            this.ticksSinceStarted = 0;
        }
        if (this.plane.getStartTime() > 0) {
            this.checkStartingLoop();
        }
    }

    public void setStarted(boolean started, boolean playSound) {
        if (this.plane.level().isClientSide() && playSound) {
            if (!started) {
                this.checkStopLoop();
            } else {
                this.checkStartLoop();
            }
        }
    }

    public void checkIdleLoop() {
        if (!this.isSoundPlaying((SoundInstance)this.idleLoop)) {
            this.idleLoop = new SoundLoopIdle(this.plane, (SoundEvent)ModSounds.ENGINE_IDLE.get(), SoundSource.NEUTRAL);
            ModClientSounds.playSoundLoop(this.idleLoop, this.plane.level());
        }
    }

    public void checkHighLoop() {
        if (!this.isSoundPlaying((SoundInstance)this.highLoop)) {
            this.highLoop = new SoundLoopHigh(this.plane, (SoundEvent)ModSounds.ENGINE_HIGH.get(), SoundSource.NEUTRAL);
            ModClientSounds.playSoundLoop(this.highLoop, this.plane.level());
        }
    }

    public void checkStartLoop() {
        if (!this.isSoundPlaying((SoundInstance)this.startLoop)) {
            this.startLoop = new SoundLoopStart(this.plane, (SoundEvent)ModSounds.ENGINE_START.get(), SoundSource.NEUTRAL);
            ModClientSounds.playSoundLoop(this.startLoop, this.plane.level());
        }
    }

    public void checkStopLoop() {
        if (!this.isSoundPlaying((SoundInstance)this.stopLoop)) {
            this.stopLoop = new SoundLoopStop(this.plane, (SoundEvent)ModSounds.ENGINE_STOP.get(), SoundSource.NEUTRAL);
            ModClientSounds.playSoundLoop(this.stopLoop, this.plane.level());
        }
    }

    public void checkStartingLoop() {
        if (!this.isSoundPlaying((SoundInstance)this.startingLoop)) {
            this.startingLoop = new SoundLoopStarting(this.plane, (SoundEvent)ModSounds.ENGINE_STARTING.get(), SoundSource.NEUTRAL);
            ModClientSounds.playSoundLoop(this.startingLoop, this.plane.level());
        }
    }

    public boolean isSoundPlaying(SoundInstance sound) {
        if (sound == null) {
            return false;
        }
        return Minecraft.getInstance().getSoundManager().isActive(sound);
    }
}

