/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.plane.corelib.client.obj.OBJModel;
import de.maxhenkel.plane.entity.EntityPlaneBase;
import de.maxhenkel.plane.entity.EntityPlaneWheelBase;
import de.maxhenkel.plane.entity.render.PlaneRenderState;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public abstract class AbstractPlaneModel<T extends EntityPlaneBase>
extends EntityRenderer<T, PlaneRenderState> {
    protected static final OBJModel WHEEL = new OBJModel(Identifier.fromNamespaceAndPath((String)"plane", (String)"models/entity/wheel.obj"));
    protected static final OBJModel PROPELLER = new OBJModel(Identifier.fromNamespaceAndPath((String)"plane", (String)"models/entity/propeller.obj"));
    protected static final Identifier WHEEL_TEXTURE = Identifier.fromNamespaceAndPath((String)"plane", (String)"textures/entity/wheel.png");
    protected static final Identifier PROPELLER_TEXTURE = Identifier.withDefaultNamespace((String)"textures/block/spruce_planks.png");
    protected static final Identifier OAK_MODEL = Identifier.withDefaultNamespace((String)"textures/block/oak_planks.png");
    protected static final Identifier DARK_OAK_MODEL = Identifier.withDefaultNamespace((String)"textures/block/dark_oak_planks.png");
    protected static final Identifier BIRCH_MODEL = Identifier.withDefaultNamespace((String)"textures/block/birch_planks.png");
    protected static final Identifier JUNGLE_MODEL = Identifier.withDefaultNamespace((String)"textures/block/jungle_planks.png");
    protected static final Identifier ACACIA_MODEL = Identifier.withDefaultNamespace((String)"textures/block/acacia_planks.png");
    protected static final Identifier SPRUCE_MODEL = Identifier.withDefaultNamespace((String)"textures/block/spruce_planks.png");
    protected static final Identifier WARPED_MODEL = Identifier.withDefaultNamespace((String)"textures/block/warped_planks.png");
    protected static final Identifier CRIMSON_MODEL = Identifier.withDefaultNamespace((String)"textures/block/crimson_planks.png");
    protected static final Identifier BAMBOO_MODEL = Identifier.withDefaultNamespace((String)"textures/block/bamboo_planks.png");
    protected static final Identifier CHERRY_MODEL = Identifier.withDefaultNamespace((String)"textures/block/cherry_planks.png");
    protected static final Identifier MANGROVE_MODEL = Identifier.withDefaultNamespace((String)"textures/block/mangrove_planks.png");
    protected static final float MODEL_SCALE = 0.0625f;
    public static final float MAX_TEXT_SCALE = 0.02f;
    public static final float MAX_TEXT_WIDTH = 0.9f;

    protected AbstractPlaneModel(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void submit(PlaneRenderState state, PoseStack stack, SubmitNodeCollector collector, CameraRenderState cameraRenderState) {
        super.submit((EntityRenderState)state, stack, collector, cameraRenderState);
        stack.pushPose();
        stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - state.yRot));
        Vec3 bodyCenter = state.bodyRotationCenter;
        stack.rotateAround((Quaternionfc)Axis.XN.rotationDegrees(state.xRot), (float)bodyCenter.x, (float)bodyCenter.y, (float)bodyCenter.z);
        stack.pushPose();
        Vector3f leftWheelOffset = this.getLeftWheelOffset(state);
        stack.translate(leftWheelOffset.x, leftWheelOffset.y, leftWheelOffset.z);
        stack.scale(0.0625f, 0.0625f, 0.0625f);
        stack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-state.wheelRotation));
        WHEEL.submitModels(WHEEL_TEXTURE, stack, collector, cameraRenderState, state.lightCoords);
        stack.popPose();
        stack.pushPose();
        Vector3f rightWheelOffset = this.getRightWheelOffset(state);
        stack.translate(rightWheelOffset.x, rightWheelOffset.y, rightWheelOffset.z);
        stack.scale(0.0625f, 0.0625f, 0.0625f);
        stack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-state.wheelRotation));
        WHEEL.submitModels(WHEEL_TEXTURE, stack, collector, cameraRenderState, state.lightCoords);
        stack.popPose();
        stack.pushPose();
        Vector3f propellerOffset = this.getPropellerOffset(state);
        stack.translate(propellerOffset.x, propellerOffset.y, propellerOffset.z);
        stack.scale(0.0625f, 0.0625f, 0.0625f);
        stack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(-state.propellerRotation));
        PROPELLER.submitModels(PROPELLER_TEXTURE, stack, collector, cameraRenderState, state.lightCoords);
        stack.popPose();
        stack.pushPose();
        Vector3f bodyOffset = this.getBodyOffset(state);
        stack.translate(bodyOffset.x, bodyOffset.y, bodyOffset.z);
        stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        this.getBodyModel(state).submitModels(this.getBodyTexture(state), stack, collector, cameraRenderState, state.lightCoords);
        stack.popPose();
        if (state.customName != null) {
            this.drawName(state, state.customName, stack, collector, state.lightCoords, true);
            this.drawName(state, state.customName, stack, collector, state.lightCoords, false);
        }
        stack.popPose();
    }

    public PlaneRenderState createRenderState() {
        return new PlaneRenderState();
    }

    public void extractRenderState(T plane, PlaneRenderState state, float partialTicks) {
        super.extractRenderState(plane, (EntityRenderState)state, partialTicks);
        state.type = ((EntityPlaneBase)((Object)plane)).getPlaneType();
        state.xRot = ((EntityPlaneBase)((Object)plane)).xRotO + (plane.getXRot() - ((EntityPlaneBase)((Object)plane)).xRotO) * state.partialTick;
        state.yRot = ((EntityPlaneBase)((Object)plane)).yRotO + (plane.getYRot() - ((EntityPlaneBase)((Object)plane)).yRotO) * state.partialTick;
        state.wheelRotation = ((EntityPlaneWheelBase)((Object)plane)).getWheelRotation(state.partialTick);
        state.propellerRotation = ((EntityPlaneWheelBase)((Object)plane)).getPropellerRotation(state.partialTick);
        state.bodyRotationCenter = ((EntityPlaneBase)((Object)plane)).getBodyRotationCenter();
        Component customName = plane.getCustomName();
        state.customName = customName == null ? null : customName.getVisualOrderText();
    }

    protected void drawName(PlaneRenderState plane, FormattedCharSequence name, PoseStack stack, SubmitNodeCollector collector, int light, boolean left) {
        stack.pushPose();
        stack.scale(1.0f, -1.0f, 1.0f);
        this.translateName(plane, stack, left);
        int textWidth = this.getFont().width(name);
        float textScale = Math.min(0.02f, 0.9f / (float)textWidth);
        stack.translate(-(textScale * (float)textWidth) / 2.0f, 0.0f, 0.0f);
        stack.scale(textScale, textScale, textScale);
        collector.submitText(stack, 0.0f, 0.0f, name, false, Font.DisplayMode.NORMAL, light, -1, 0, 0);
        stack.popPose();
    }

    protected abstract void translateName(PlaneRenderState var1, PoseStack var2, boolean var3);

    protected abstract Vector3f getLeftWheelOffset(PlaneRenderState var1);

    protected abstract Vector3f getRightWheelOffset(PlaneRenderState var1);

    protected abstract Vector3f getPropellerOffset(PlaneRenderState var1);

    protected abstract Vector3f getBodyOffset(PlaneRenderState var1);

    protected abstract OBJModel getBodyModel(PlaneRenderState var1);

    protected abstract Identifier getBodyTexture(PlaneRenderState var1);

    protected boolean shouldShowName(T entity, double d) {
        return false;
    }
}

