/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.events;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.plane.ClientConfig;
import de.maxhenkel.plane.PlaneMod;
import de.maxhenkel.plane.corelib.FontColorUtils;
import de.maxhenkel.plane.corelib.math.MathUtils;
import de.maxhenkel.plane.entity.EntityPlaneBase;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.CalculateDetachedCameraDistanceEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.joml.Quaternionfc;

public class RenderEvents {
    private static final Identifier PLANE_INFO_TEXTURE = Identifier.fromNamespaceAndPath((String)"plane", (String)"textures/gui/plane_info.png");
    private Minecraft mc = Minecraft.getInstance();
    private EntityPlaneSoundBase lastVehicle;
    private double cachedRelativeHeight = 0.0;

    @SubscribeEvent
    public void onCameraDistance(CalculateDetachedCameraDistanceEvent evt) {
        if (this.getPlane() != null && !this.mc.options.getCameraType().isFirstPerson()) {
            evt.setDistance(((Double)PlaneMod.CLIENT_CONFIG.planeZoom.get()).floatValue());
        }
    }

    @SubscribeEvent
    public void onScroll(InputEvent.MouseScrollingEvent evt) {
        if (this.getPlane() != null && !this.mc.options.getCameraType().isFirstPerson()) {
            PlaneMod.CLIENT_CONFIG.planeZoom.set((Object)Math.max(1.0, Math.min(20.0, (Double)PlaneMod.CLIENT_CONFIG.planeZoom.get() - evt.getScrollDeltaY())));
            PlaneMod.CLIENT_CONFIG.planeZoom.save();
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRender(RenderGuiLayerEvent.Post evt) {
        if (!VanillaGuiLayers.HOTBAR.equals((Object)evt.getName())) {
            return;
        }
        if (this.mc.options.hideGui) {
            return;
        }
        LocalPlayer player = this.mc.player;
        Entity e = player.getVehicle();
        if (!(e instanceof EntityPlaneBase)) {
            return;
        }
        EntityPlaneBase plane = (EntityPlaneBase)e;
        if (((Boolean)PlaneMod.CLIENT_CONFIG.showPlaneInfo.get()).booleanValue()) {
            this.renderPlaneInfo(evt.getGuiGraphics(), plane);
        }
    }

    public void renderPlaneInfo(GuiGraphics guiGraphics, EntityPlaneSoundBase plane) {
        guiGraphics.pose().pushMatrix();
        int texWidth = 110;
        int texHeight = 90;
        int height = this.mc.getWindow().getGuiScaledHeight();
        int width = this.mc.getWindow().getGuiScaledWidth();
        float scale = ((Double)PlaneMod.CLIENT_CONFIG.planeInfoScale.get()).floatValue();
        guiGraphics.pose().scale(scale, scale);
        guiGraphics.pose().translate((float)(-width), (float)(-height));
        guiGraphics.pose().translate((float)width * (1.0f / scale), (float)height * (1.0f / scale));
        int padding = 3;
        int yStart = height - texHeight - padding;
        int xStart = width - texWidth - padding;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, PLANE_INFO_TEXTURE, xStart, yStart, 0.0f, 0.0f, texWidth, texHeight, 256, 256);
        Font font = this.mc.gui.getFont();
        Function<Integer, Integer> heightFunc = integer -> {
            Objects.requireNonNull(font);
            return yStart + 8 + (9 + 2) * integer;
        };
        int black = FontColorUtils.getFontColor(ChatFormatting.BLACK);
        guiGraphics.drawString(font, Component.translatable((String)"tooltip.plane.speed", (Object[])new Object[]{((ClientConfig.SpeedType)((Object)PlaneMod.CLIENT_CONFIG.planeInfoSpeedType.get())).getTextComponent(plane.getDeltaMovement().length())}).getVisualOrderText(), xStart + 7, heightFunc.apply(0).intValue(), black, false);
        guiGraphics.drawString(font, Component.translatable((String)"tooltip.plane.vertical_speed", (Object[])new Object[]{((ClientConfig.SpeedType)((Object)PlaneMod.CLIENT_CONFIG.planeInfoSpeedType.get())).getTextComponent(plane.getDeltaMovement().y())}).getVisualOrderText(), xStart + 7, heightFunc.apply(1).intValue(), black, false);
        guiGraphics.drawString(font, Component.translatable((String)"tooltip.plane.throttle", (Object[])new Object[]{String.valueOf(Math.round(plane.getEngineSpeed() * 100.0f))}).getVisualOrderText(), xStart + 7, heightFunc.apply(2).intValue(), black, false);
        guiGraphics.drawString(font, Component.translatable((String)"tooltip.plane.height", (Object[])new Object[]{String.valueOf(Math.round(plane.getY()))}).getVisualOrderText(), xStart + 7, heightFunc.apply(3).intValue(), black, false);
        guiGraphics.drawString(font, Component.translatable((String)"tooltip.plane.relative_height", (Object[])new Object[]{String.valueOf(Math.round(this.cachedRelativeHeight))}).getVisualOrderText(), xStart + 7, heightFunc.apply(4).intValue(), black, false);
        guiGraphics.drawString(font, Component.translatable((String)"tooltip.plane.fuel", (Object[])new Object[]{String.valueOf(plane.getFuel())}).getVisualOrderText(), xStart + 7, heightFunc.apply(5).intValue(), black, false);
        guiGraphics.drawString(font, Component.translatable((String)"tooltip.plane.damage", (Object[])new Object[]{String.valueOf(MathUtils.round(plane.getPlaneDamage(), 2))}).getVisualOrderText(), xStart + 7, heightFunc.apply(6).intValue(), black, false);
        guiGraphics.pose().popMatrix();
    }

    private double getRelativeHeight(EntityPlaneSoundBase plane) {
        int highestBlock = (int)plane.getY();
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos(plane.getX(), plane.getY(), plane.getZ());
        for (int y = highestBlock; y >= plane.level().getMinY(); --y) {
            p.setY(y);
            if (!plane.level().getBlockState((BlockPos)p).canOcclude()) continue;
            highestBlock = y;
            break;
        }
        return plane.getY() - (double)(highestBlock + 1);
    }

    @SubscribeEvent
    public void renderPlayerPre(RenderPlayerEvent.Pre<AbstractClientPlayer> event) {
        if (this.mc.level == null) {
            return;
        }
        Entity entity = this.mc.level.getEntity(((AvatarRenderState)event.getRenderState()).id);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Entity entity2 = player.getVehicle();
        if (entity2 instanceof EntityPlaneBase) {
            EntityPlaneBase plane = (EntityPlaneBase)entity2;
            PoseStack pose = event.getPoseStack();
            pose.pushPose();
            pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-(plane.yRotO + (plane.getYRot() - plane.yRotO) * event.getPartialTick())));
            Vec3 bodyRotationCenter = plane.getBodyRotationCenter();
            pose.mulPose((Quaternionfc)Axis.XP.rotationDegrees(plane.xRotO + (plane.getXRot() - plane.xRotO) * event.getPartialTick()));
            List passengers = plane.getPassengers();
            int i = passengers.indexOf(player);
            if (i >= 0) {
                Vec3 offset = plane.getPlayerOffsets()[i];
                offset = offset.add(bodyRotationCenter);
                offset = offset.xRot((float)(-Math.toRadians(plane.getXRot())));
                pose.translate(0.0, offset.y, 0.0);
            }
            pose.scale(plane.getPlayerScaleFactor(), plane.getPlayerScaleFactor(), plane.getPlayerScaleFactor());
            pose.translate(0.0f, (player.getBbHeight() - player.getBbHeight() * plane.getPlayerScaleFactor()) / 1.5f + (float)plane.getPlayerOffsets()[0].y, 0.0f);
            pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees(plane.yRotO + (plane.getYRot() - plane.yRotO) * event.getPartialTick()));
        }
    }

    @SubscribeEvent
    public void renderPlayerPost(RenderPlayerEvent.Post<AbstractClientPlayer> event) {
        if (this.mc.level == null) {
            return;
        }
        Entity entity = this.mc.level.getEntity(((AvatarRenderState)event.getRenderState()).id);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.getVehicle() instanceof EntityPlaneBase) {
            event.getPoseStack().popPose();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Pre evt) {
        if (!evt.getEntity().equals((Object)this.mc.player)) {
            return;
        }
        EntityPlaneSoundBase vehicle = this.getPlane();
        if (vehicle != null && evt.getEntity().equals((Object)vehicle.getDriver())) {
            this.cachedRelativeHeight = this.getRelativeHeight(vehicle);
        }
        if (vehicle != null && this.lastVehicle == null) {
            this.mc.options.setCameraType(CameraType.THIRD_PERSON_BACK);
        } else if (vehicle == null && this.lastVehicle != null) {
            this.mc.options.setCameraType(CameraType.FIRST_PERSON);
        }
        this.lastVehicle = vehicle;
    }

    private EntityPlaneSoundBase getPlane() {
        if (this.mc.player.getVehicle() instanceof EntityPlaneSoundBase) {
            return (EntityPlaneSoundBase)this.mc.player.getVehicle();
        }
        return null;
    }
}

