/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.gui;

import de.maxhenkel.plane.corelib.inventory.ScreenBase;
import de.maxhenkel.plane.corelib.math.MathUtils;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import de.maxhenkel.plane.gui.ContainerPlane;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;

public class PlaneScreen
extends ScreenBase<ContainerPlane> {
    private static final Identifier CAR_GUI_TEXTURE = Identifier.fromNamespaceAndPath((String)"plane", (String)"textures/gui/gui_plane.png");
    private static final Component TEXT_FUEL = Component.translatable((String)"gui.plane.fuel");
    private static final Component TEXT_DAMAGE = Component.translatable((String)"gui.plane.damage");
    private static final Component TEXT_ENGINE = Component.translatable((String)"gui.plane.throttle");
    private Inventory playerInv;
    private EntityPlaneSoundBase plane;

    public PlaneScreen(ContainerPlane containerCar, Inventory playerInv, Component title) {
        super(CAR_GUI_TEXTURE, containerCar, playerInv, title);
        this.playerInv = playerInv;
        this.plane = containerCar.getPlane();
        this.imageWidth = 176;
        this.imageHeight = 222;
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<FormattedCharSequence> list;
        super.renderLabels(guiGraphics, mouseX, mouseY);
        guiGraphics.drawString(this.font, this.plane.getName().getVisualOrderText(), 7, 61, -12566464, false);
        guiGraphics.drawString(this.font, this.playerInv.getDisplayName().getVisualOrderText(), 8, this.imageHeight - 96 + 2, -12566464, false);
        guiGraphics.drawString(this.font, TEXT_FUEL.getVisualOrderText(), 7, 9, -12566464, false);
        guiGraphics.drawString(this.font, TEXT_DAMAGE.getVisualOrderText(), 95, 9, -12566464, false);
        guiGraphics.drawString(this.font, TEXT_ENGINE.getVisualOrderText(), 7, 35, -12566464, false);
        if (mouseX >= this.leftPos + 8 && mouseX < this.leftPos + 80 && mouseY >= this.topPos + 20 && mouseY < this.topPos + 30) {
            list = new ArrayList<FormattedCharSequence>();
            list.add(Component.translatable((String)"tooltip.plane.fuel", (Object[])new Object[]{String.valueOf(this.plane.getFuel())}).getVisualOrderText());
            guiGraphics.setTooltipForNextFrame(this.font, list, mouseX, mouseY);
        }
        if (mouseX >= this.leftPos + 96 && mouseX < this.leftPos + 168 && mouseY >= this.topPos + 20 && mouseY < this.topPos + 30) {
            list = new ArrayList();
            list.add(Component.translatable((String)"tooltip.plane.damage", (Object[])new Object[]{String.valueOf(MathUtils.round(this.plane.getPlaneDamage(), 2))}).getVisualOrderText());
            guiGraphics.setTooltipForNextFrame(this.font, list, mouseX, mouseY);
        }
        if (mouseX >= this.leftPos + 8 && mouseX < this.leftPos + 80 && mouseY >= this.topPos + 46 && mouseY < this.topPos + 56) {
            list = new ArrayList();
            list.add(Component.translatable((String)"tooltip.plane.throttle", (Object[])new Object[]{String.valueOf(Math.round(this.plane.getEngineSpeed() * 100.0f))}).getVisualOrderText());
            guiGraphics.setTooltipForNextFrame(this.font, list, mouseX, mouseY);
        }
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        this.drawFuel(guiGraphics, (float)this.plane.getFuel() / (float)this.plane.getFuelCapacity());
        this.drawDamage(guiGraphics, (100.0f - Math.min(this.plane.getPlaneDamage(), 100.0f)) / 100.0f);
        this.drawThrottle(guiGraphics, this.plane.getEngineSpeed());
    }

    public void drawFuel(GuiGraphics guiGraphics, float percent) {
        int scaled = (int)(72.0f * percent);
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, i + 8, j + 20, 176.0f, 0.0f, scaled, 10, 256, 256);
    }

    public void drawThrottle(GuiGraphics guiGraphics, float percent) {
        int scaled = (int)(72.0f * percent);
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, i + 8, j + 46, 176.0f, 10.0f, scaled, 10, 256, 256);
    }

    public void drawDamage(GuiGraphics guiGraphics, float percent) {
        int scaled = (int)(72.0f * percent);
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, i + 96, j + 20, 176.0f, 20.0f, scaled, 10, 256, 256);
    }
}

