/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.item;

import com.mojang.serialization.Codec;
import de.maxhenkel.plane.corelib.codec.ValueInputOutputUtils;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;

public class PlaneData {
    public static final Codec<PlaneData> CODEC = CompoundTag.CODEC.xmap(PlaneData::new, PlaneData::getPlaneData);
    public static final StreamCodec<RegistryFriendlyByteBuf, PlaneData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, PlaneData::getDamage, (StreamCodec)ByteBufCodecs.INT, PlaneData::getFuel, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, PlaneData::getPlaneData, PlaneData::new);
    private final float damage;
    private final int fuel;
    private final CompoundTag planeData;

    private PlaneData(float damage, int fuel, CompoundTag planeData) {
        this.damage = damage;
        this.fuel = fuel;
        this.planeData = planeData;
    }

    private PlaneData(CompoundTag planeData) {
        this.damage = planeData.getFloatOr("Damage", 0.0f);
        this.fuel = planeData.getIntOr("Fuel", 0);
        this.planeData = planeData;
    }

    public static PlaneData of(EntityPlaneSoundBase entity) {
        TagValueOutput valueOutput = ValueInputOutputUtils.createValueOutput(entity, (HolderLookup.Provider)entity.registryAccess());
        entity.addAdditionalSaveData((ValueOutput)valueOutput);
        return new PlaneData(ValueInputOutputUtils.toTag(valueOutput));
    }

    public static PlaneData of(CompoundTag tag) {
        return new PlaneData(tag.copy());
    }

    public float getDamage() {
        return this.damage;
    }

    public int getFuel() {
        return this.fuel;
    }

    private CompoundTag getPlaneData() {
        return this.planeData;
    }

    public CompoundTag getPlaneDataCopy() {
        return this.planeData.copy();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlaneData planeData1 = (PlaneData)o;
        return Float.compare(this.damage, planeData1.damage) == 0 && this.fuel == planeData1.fuel && Objects.equals(this.planeData, planeData1.planeData);
    }

    public int hashCode() {
        int result = Float.hashCode(this.damage);
        result = 31 * result + this.fuel;
        result = 31 * result + Objects.hashCode(this.planeData);
        return result;
    }
}

