/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.loottable;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.maxhenkel.plane.PlaneMod;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import de.maxhenkel.plane.item.ModItems;
import de.maxhenkel.plane.item.PlaneData;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class CopyPlaneData
extends LootItemConditionalFunction {
    public static final MapCodec<CopyPlaneData> CODEC = RecordCodecBuilder.mapCodec(instance -> CopyPlaneData.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, CopyPlaneData::new));

    protected CopyPlaneData(List<LootItemCondition> conditions) {
        super(conditions);
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        Entity entity = (Entity)context.getOptionalParameter(LootContextParams.THIS_ENTITY);
        if (!(entity instanceof EntityPlaneSoundBase)) {
            return stack;
        }
        EntityPlaneSoundBase plane = (EntityPlaneSoundBase)entity;
        stack.set(ModItems.PLANE_DATA_COMPONENT, (Object)PlaneData.of(plane));
        if (plane.hasCustomName()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)plane.getCustomName());
        }
        return stack;
    }

    public LootItemFunctionType getType() {
        return (LootItemFunctionType)PlaneMod.COPY_PLANE_DATA.get();
    }
}

