/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.net;

import de.maxhenkel.plane.corelib.net.Message;
import de.maxhenkel.plane.entity.EntityPlaneControlBase;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageControlPlane
implements Message<MessageControlPlane> {
    public static final CustomPacketPayload.Type<MessageControlPlane> TYPE = new CustomPacketPayload.Type(Identifier.fromNamespaceAndPath((String)"plane", (String)"control_plane"));
    private boolean up;
    private boolean down;
    private boolean thrustPos;
    private boolean thrustNeg;
    private boolean left;
    private boolean right;
    private boolean braking;
    private boolean starting;

    public MessageControlPlane() {
        this.up = false;
        this.down = false;
        this.thrustPos = false;
        this.thrustNeg = false;
        this.left = false;
        this.right = false;
        this.braking = false;
        this.starting = false;
    }

    public MessageControlPlane(boolean up, boolean down, boolean thrustPos, boolean thrustNeg, boolean left, boolean right, boolean braking, boolean starting) {
        this.up = up;
        this.down = down;
        this.thrustPos = thrustPos;
        this.thrustNeg = thrustNeg;
        this.left = left;
        this.right = right;
        this.braking = braking;
        this.starting = starting;
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)player;
        Entity entity = sender.getVehicle();
        if (!(entity instanceof EntityPlaneControlBase)) {
            return;
        }
        EntityPlaneControlBase plane = (EntityPlaneControlBase)entity;
        plane.updateControls(this.up, this.down, this.thrustPos, this.thrustNeg, this.left, this.right, this.braking, this.starting);
    }

    @Override
    public MessageControlPlane fromBytes(RegistryFriendlyByteBuf buf) {
        this.up = buf.readBoolean();
        this.down = buf.readBoolean();
        this.thrustPos = buf.readBoolean();
        this.thrustNeg = buf.readBoolean();
        this.left = buf.readBoolean();
        this.right = buf.readBoolean();
        this.braking = buf.readBoolean();
        this.starting = buf.readBoolean();
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeBoolean(this.up);
        buf.writeBoolean(this.down);
        buf.writeBoolean(this.thrustPos);
        buf.writeBoolean(this.thrustNeg);
        buf.writeBoolean(this.left);
        buf.writeBoolean(this.right);
        buf.writeBoolean(this.braking);
        buf.writeBoolean(this.starting);
    }

    @Override
    public CustomPacketPayload.Type<MessageControlPlane> type() {
        return TYPE;
    }
}

