/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.net;

import de.maxhenkel.plane.corelib.net.Message;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessagePlaneGui
implements Message<MessagePlaneGui> {
    public static final CustomPacketPayload.Type<MessagePlaneGui> TYPE = new CustomPacketPayload.Type(Identifier.fromNamespaceAndPath((String)"plane", (String)"plane_gui"));
    private UUID uuid;
    private boolean outside;

    public MessagePlaneGui() {
        this.uuid = new UUID(0L, 0L);
    }

    public MessagePlaneGui(Player player, boolean outside) {
        this.uuid = player.getUUID();
        this.outside = outside;
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)player;
        if (!sender.getUUID().equals(this.uuid)) {
            return;
        }
        Entity entity = sender.getVehicle();
        if (entity instanceof EntityPlaneSoundBase) {
            EntityPlaneSoundBase plane = (EntityPlaneSoundBase)entity;
            plane.openGUI((Player)sender, this.outside);
        }
    }

    @Override
    public MessagePlaneGui fromBytes(RegistryFriendlyByteBuf buf) {
        this.uuid = buf.readUUID();
        this.outside = buf.readBoolean();
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeUUID(this.uuid);
        buf.writeBoolean(this.outside);
    }

    @Override
    public CustomPacketPayload.Type<MessagePlaneGui> type() {
        return TYPE;
    }
}

