/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.sound;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModSounds {
    private static final DeferredRegister<SoundEvent> SOUND_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.SOUND_EVENT, (String)"plane");
    public static final DeferredHolder<SoundEvent, SoundEvent> ENGINE_STOP = ModSounds.addSound("engine_stop");
    public static final DeferredHolder<SoundEvent, SoundEvent> ENGINE_STARTING = ModSounds.addSound("engine_starting");
    public static final DeferredHolder<SoundEvent, SoundEvent> ENGINE_START = ModSounds.addSound("engine_start");
    public static final DeferredHolder<SoundEvent, SoundEvent> ENGINE_IDLE = ModSounds.addSound("engine_idle");
    public static final DeferredHolder<SoundEvent, SoundEvent> ENGINE_HIGH = ModSounds.addSound("engine_high");
    public static final DeferredHolder<SoundEvent, SoundEvent> CRASH = ModSounds.addSound("crash");
    public static final DeferredHolder<SoundEvent, SoundEvent> RATCHET = ModSounds.addSound("ratchet");

    public static DeferredHolder<SoundEvent, SoundEvent> addSound(String soundName) {
        return SOUND_REGISTER.register(soundName, () -> SoundEvent.createVariableRangeEvent((Identifier)Identifier.fromNamespaceAndPath((String)"plane", (String)soundName)));
    }

    public static void init(IEventBus eventBus) {
        SOUND_REGISTER.register(eventBus);
    }

    public static void playSound(SoundEvent evt, Level world, BlockPos pos, Player entity, SoundSource category, float volume) {
        ModSounds.playSound(evt, world, pos, entity, category, volume, 1.0f);
    }

    public static void playSound(SoundEvent evt, Level world, BlockPos pos, Player entity, SoundSource category, float volume, float pitch) {
        if (entity != null) {
            world.playSound((Entity)entity, pos, evt, category, volume, pitch);
        } else if (!world.isClientSide()) {
            world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, evt, category, volume, pitch);
        }
    }
}

