/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.bundlepins.data;

import com.boyonk.bundlepins.BundlePin;
import com.boyonk.bundlepins.BundlePins;
import com.boyonk.bundlepins.data.compat.AesCompatDataGenerator;
import com.boyonk.bundlepins.data.server.recipe.BundlePinRecipeGenerator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricDynamicRegistryProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_2446;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7877;
import net.minecraft.class_7891;
import net.minecraft.class_8790;

public class BundlePinsDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator generator) {
        FabricDataGenerator.Pack pack = generator.createPack();
        pack.addProvider(RegistryProvider::new);
        pack.addProvider(RecipeProvider::new);
        pack.addProvider(EnglishLanguageProvider::new);
        pack.addProvider(DutchLanguageProvider::new);
        AesCompatDataGenerator.initialize(generator.createBuiltinResourcePack(BundlePins.COMPAT_AES));
    }

    public void buildRegistry(class_7877 registryBuilder) {
        registryBuilder.method_46777(BundlePins.REGISTRY, BundlePinsDataGenerator::bootstrap);
    }

    public static void bootstrap(class_7891<BundlePin> registerable) {
        AesCompatDataGenerator.bootstrap(registerable);
        BundlePinsDataGenerator.register(registerable, BundlePins.QUARTZ, class_2583.field_24360.method_36139(-1846076));
        BundlePinsDataGenerator.register(registerable, BundlePins.IRON, class_2583.field_24360.method_36139(-1250068));
        BundlePinsDataGenerator.register(registerable, BundlePins.NETHERITE, class_2583.field_24360.method_36139(-10332071));
        BundlePinsDataGenerator.register(registerable, BundlePins.COPPER, class_2583.field_24360.method_36139(-4954035));
        BundlePinsDataGenerator.register(registerable, BundlePins.GOLD, class_2583.field_24360.method_36139(-2182867));
        BundlePinsDataGenerator.register(registerable, BundlePins.EMERALD, class_2583.field_24360.method_36139(-15622090));
        BundlePinsDataGenerator.register(registerable, BundlePins.DIAMOND, class_2583.field_24360.method_36139(-9507630));
        BundlePinsDataGenerator.register(registerable, BundlePins.LAPIS, class_2583.field_24360.method_36139(-12489065));
        BundlePinsDataGenerator.register(registerable, BundlePins.AMETHYST, class_2583.field_24360.method_36139(-6660922));
        BundlePinsDataGenerator.register(registerable, BundlePins.RESIN, class_2583.field_24360.method_36139(-231406));
    }

    public static void register(class_7891<BundlePin> registerable, class_5321<BundlePin> key, class_2583 style) {
        registerable.method_46838(key, (Object)new BundlePin(key.method_29177(), (class_2561)class_2561.method_43471((String)class_156.method_646((String)"bundle_pin", (class_2960)key.method_29177())).method_10862(style), Optional.ofNullable(style.method_10973())));
    }

    public static void add(FabricLanguageProvider.TranslationBuilder builder, class_5321<BundlePin> key, String value) {
        builder.add(class_156.method_646((String)"bundle_pin", (class_2960)key.method_29177()), value);
    }

    private static class DutchLanguageProvider
    extends FabricLanguageProvider {
        protected DutchLanguageProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, "nl_nl", registryLookup);
        }

        public void generateTranslations(class_7225.class_7874 registryLookup, FabricLanguageProvider.TranslationBuilder builder) {
            BundlePinsDataGenerator.add(builder, BundlePins.QUARTZ, "Kwartsspeld");
            BundlePinsDataGenerator.add(builder, BundlePins.IRON, "IJzerspeld");
            BundlePinsDataGenerator.add(builder, BundlePins.NETHERITE, "Netherietspeld");
            BundlePinsDataGenerator.add(builder, BundlePins.COPPER, "Koperspeld");
            BundlePinsDataGenerator.add(builder, BundlePins.GOLD, "Goudspeld");
            BundlePinsDataGenerator.add(builder, BundlePins.EMERALD, "Smaragdspeld");
            BundlePinsDataGenerator.add(builder, BundlePins.DIAMOND, "Diamantspeld");
            BundlePinsDataGenerator.add(builder, BundlePins.LAPIS, "Lapislazulispeld");
            BundlePinsDataGenerator.add(builder, BundlePins.AMETHYST, "Amethistspeld");
            BundlePinsDataGenerator.add(builder, BundlePins.RESIN, "Harsspeld");
        }
    }

    private static class EnglishLanguageProvider
    extends FabricLanguageProvider {
        protected EnglishLanguageProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, "en_us", registryLookup);
        }

        public void generateTranslations(class_7225.class_7874 registryLookup, FabricLanguageProvider.TranslationBuilder builder) {
            BundlePinsDataGenerator.add(builder, BundlePins.QUARTZ, "Quartz Pin");
            BundlePinsDataGenerator.add(builder, BundlePins.IRON, "Iron Pin");
            BundlePinsDataGenerator.add(builder, BundlePins.NETHERITE, "Netherite Pin");
            BundlePinsDataGenerator.add(builder, BundlePins.COPPER, "Copper Pin");
            BundlePinsDataGenerator.add(builder, BundlePins.GOLD, "Gold Pin");
            BundlePinsDataGenerator.add(builder, BundlePins.EMERALD, "Emerald Pin");
            BundlePinsDataGenerator.add(builder, BundlePins.DIAMOND, "Diamond Pin");
            BundlePinsDataGenerator.add(builder, BundlePins.LAPIS, "Lapis Pin");
            BundlePinsDataGenerator.add(builder, BundlePins.AMETHYST, "Amethyst Pin");
            BundlePinsDataGenerator.add(builder, BundlePins.RESIN, "Resin Pin");
        }
    }

    private static class RecipeProvider
    extends FabricRecipeProvider {
        public RecipeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        protected class_2446 method_62766(class_7225.class_7874 wrapperLookup, class_8790 exporter) {
            return new BundlePinRecipeGenerator(this, wrapperLookup, exporter){

                public void method_10419() {
                    this.offerBundlePinRecipe(BundlePins.QUARTZ, (class_6862<class_1792>)ConventionalItemTags.QUARTZ_GEMS);
                    this.offerBundlePinRecipe(BundlePins.IRON, (class_6862<class_1792>)ConventionalItemTags.IRON_INGOTS);
                    this.offerBundlePinRecipe(BundlePins.NETHERITE, (class_6862<class_1792>)ConventionalItemTags.NETHERITE_INGOTS);
                    this.offerBundlePinRecipe(BundlePins.COPPER, (class_6862<class_1792>)ConventionalItemTags.COPPER_INGOTS);
                    this.offerBundlePinRecipe(BundlePins.GOLD, (class_6862<class_1792>)ConventionalItemTags.GOLD_INGOTS);
                    this.offerBundlePinRecipe(BundlePins.EMERALD, (class_6862<class_1792>)ConventionalItemTags.EMERALD_GEMS);
                    this.offerBundlePinRecipe(BundlePins.DIAMOND, (class_6862<class_1792>)ConventionalItemTags.DIAMOND_GEMS);
                    this.offerBundlePinRecipe(BundlePins.LAPIS, (class_6862<class_1792>)ConventionalItemTags.LAPIS_GEMS);
                    this.offerBundlePinRecipe(BundlePins.AMETHYST, (class_6862<class_1792>)ConventionalItemTags.AMETHYST_GEMS);
                    this.offerBundlePinRecipe(BundlePins.RESIN, (class_6862<class_1792>)ConventionalItemTags.RESIN_BRICKS);
                }
            };
        }

        public String method_10321() {
            return "Recipes";
        }
    }

    static class RegistryProvider
    extends FabricDynamicRegistryProvider {
        public RegistryProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void configure(class_7225.class_7874 registries, FabricDynamicRegistryProvider.Entries entries) {
            class_7225.class_7226 registry = registries.method_46762(BundlePins.REGISTRY);
            entries.add(registry, BundlePins.QUARTZ);
            entries.add(registry, BundlePins.IRON);
            entries.add(registry, BundlePins.NETHERITE);
            entries.add(registry, BundlePins.COPPER);
            entries.add(registry, BundlePins.GOLD);
            entries.add(registry, BundlePins.EMERALD);
            entries.add(registry, BundlePins.DIAMOND);
            entries.add(registry, BundlePins.LAPIS);
            entries.add(registry, BundlePins.AMETHYST);
            entries.add(registry, BundlePins.RESIN);
        }

        public String method_10321() {
            return "Registry";
        }
    }
}

