package com.boyonk.bundlepins;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_5381;
import net.minecraft.class_6880;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record BundlePin(class_2960 assetId, class_2561 description, Optional<class_5251> itemBarColor) {
	public static final Codec<BundlePin> CODEC = RecordCodecBuilder.create(instance ->
			instance.group(
					class_2960.field_25139
							.fieldOf("asset_id")
							.forGetter(BundlePin::assetId),
					class_8824.field_46597
							.fieldOf("description")
							.forGetter(BundlePin::description),
					class_5251.field_39242
							.optionalFieldOf("item_bar_color")
							.forGetter(BundlePin::itemBarColor)
			).apply(instance, BundlePin::new)
	);

	public static final class_9139<ByteBuf, BundlePin> PACKET_CODEC = class_9139.method_56436(
			class_2960.field_48267, BundlePin::assetId,
			class_8824.field_49668, BundlePin::description,
			class_9135.method_56382(class_9135.method_56368(class_5251.field_39242)), BundlePin::itemBarColor,
			BundlePin::new
	);
	public static final Codec<class_6880<BundlePin>> ENTRY_CODEC = class_5381.method_29749(BundlePins.REGISTRY, CODEC);
	public static final class_9139<class_9129, class_6880<BundlePin>> ENTRY_PACKET_CODEC = class_9135.method_56367(BundlePins.REGISTRY, PACKET_CODEC);
	public static final Codec<class_5321<BundlePin>> KEY_CODEC = class_5321.method_39154(BundlePins.REGISTRY);
	public static final class_9139<ByteBuf, class_5321<BundlePin>> KEY_PACKET_CODEC = class_5321.method_56038(BundlePins.REGISTRY);

}
