package com.boyonk.bundlepins;

import com.boyonk.bundlepins.recipe.BundlePinRecipe;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1865;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import net.minecraft.registry.*;
import java.util.Optional;

public class BundlePins implements ModInitializer {

	public static final String NAMESPACE = "bundle_pins";


	public static final class_5321<class_2378<BundlePin>> REGISTRY = class_5321.method_29180(class_2960.method_60656("bundle_pins"));
	public static final class_9331<class_6880<BundlePin>> DATA_COMPONENT_TYPE = new class_9331.class_9332<class_6880<BundlePin>>().method_57881(BundlePin.ENTRY_CODEC).method_57880();
	public static final class_1865<BundlePinRecipe> RECIPE_SERIALIZER = new BundlePinRecipe.Serializer();

	public static final class_5321<BundlePin> QUARTZ = of("quartz");
	public static final class_5321<BundlePin> IRON = of("iron");
	public static final class_5321<BundlePin> NETHERITE = of("netherite");
	public static final class_5321<BundlePin> COPPER = of("copper");
	public static final class_5321<BundlePin> GOLD = of("gold");
	public static final class_5321<BundlePin> EMERALD = of("emerald");
	public static final class_5321<BundlePin> DIAMOND = of("diamond");
	public static final class_5321<BundlePin> LAPIS = of("lapis");
	public static final class_5321<BundlePin> AMETHYST = of("amethyst");
	public static final class_5321<BundlePin> RESIN = of("resin");

	public static class_5321<BundlePin> of(String path) {
		return class_5321.method_29179(REGISTRY, class_2960.method_60655(NAMESPACE, path));
	}

	public static final class_2960 COMPAT_AES = class_2960.method_60655(NAMESPACE, "compat/aes");

	@Override
	public void onInitialize() {
		DynamicRegistries.registerSynced(REGISTRY, BundlePin.CODEC, DynamicRegistries.SyncOption.SKIP_WHEN_EMPTY);
		class_2378.method_10230(class_7923.field_49658, class_2960.method_60655(NAMESPACE, "bundle_pin"), DATA_COMPONENT_TYPE);
		class_2378.method_10230(class_7923.field_41189, class_2960.method_60655(NAMESPACE, "bundle_pin"), RECIPE_SERIALIZER);

		if (FabricLoader.getInstance().isModLoaded("aes") || FabricLoader.getInstance().isModLoaded("tvxiii")) {
			ResourceManagerHelper.registerBuiltinResourcePack(COMPAT_AES, getModContainerOrThrow(), ResourcePackActivationType.ALWAYS_ENABLED);
		}
	}

	public static ModContainer getModContainerOrThrow() {
		return FabricLoader.getInstance().getModContainer(NAMESPACE).orElseThrow();
	}

	public static Optional<class_6880.class_6883<BundlePin>> get(class_7225.class_7874 registriesLookup, class_5321<BundlePin> key) {
		return registriesLookup.method_46762(REGISTRY).method_46746(key);
	}


}
